/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Serializer;

class FloatSerializer
extends Serializer<Float> {
    FloatSerializer() {
        super(Float.class);
    }

    @Override
    public void calcSize(Float obj, CalcSizeStream css) {
        css.count += 4;
    }

    @Override
    public void write(Float v, DataStream out) throws IOException {
        out.writeFloat(v.floatValue());
    }

    @Override
    public Float read(DataStream in) throws IOException {
        Float result = Float.valueOf(in.readFloat());
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(4);
    }

    @Override
    public void toJson(Float obj, StringBuilder builder) {
        builder.append(obj.floatValue());
    }

    @Override
    public Float fromJson(JsonReader in) throws IOException {
        return Float.valueOf(in.readFloat());
    }

    @Override
    public Float fromString(String s) {
        return Float.valueOf(s);
    }
}

