/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.gen.BytecodeGenerator;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Renamed;
import one.nio.serial.Serializer;
import one.nio.serial.TypeDescriptor;
import one.nio.util.Utf8;

class ClassSerializer
extends Serializer<Class<?>> {
    ClassSerializer() {
        super(Class.class);
    }

    @Override
    public void calcSize(Class<?> obj, CalcSizeStream css) {
        if (obj.isPrimitive()) {
            ++css.count;
        } else {
            int length = Utf8.length(obj.getName());
            Renamed renamed = obj.getAnnotation(Renamed.class);
            css.count = css.count + (renamed == null ? 3 + length : 4 + length + Utf8.length(renamed.from()));
        }
    }

    @Override
    public void write(Class<?> obj, DataStream out) throws IOException {
        TypeDescriptor.writeClass(out, obj);
    }

    @Override
    public Class<?> read(DataStream in) throws IOException, ClassNotFoundException {
        Class<?> result = TypeDescriptor.readClass(in);
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        if (in.readByte() < 0) {
            in.skipBytes(in.readUnsignedShort());
        }
    }

    @Override
    public void toJson(Class<?> obj, StringBuilder builder) {
        builder.append('\"').append(obj.getName()).append('\"');
    }

    @Override
    public Class<?> fromJson(JsonReader in) throws IOException, ClassNotFoundException {
        return this.fromString(in.readString());
    }

    @Override
    public Class<?> fromString(String s) throws ClassNotFoundException {
        switch (s) {
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return Class.forName(s, false, BytecodeGenerator.INSTANCE);
    }
}

