/*
 * Decompiled with CFR 0.152.
 */
package one.nio.pool;

import java.io.Closeable;
import java.util.LinkedList;
import one.nio.pool.PoolException;

public abstract class Pool<T>
extends LinkedList<T>
implements Closeable {
    protected boolean closed;
    protected boolean keepEmpty;
    protected boolean fifo;
    protected int initialCount;
    protected int createdCount;
    protected int maxCount;
    protected int timeout;
    protected int timeouts;
    protected int waitingThreads;

    protected Pool(int initialCount, int maxCount, int timeout) {
        this.initialCount = initialCount;
        this.maxCount = maxCount;
        this.timeout = timeout;
    }

    @Override
    public synchronized void close() {
        this.invalidateAll();
        this.keepEmpty = true;
        this.closed = true;
    }

    public String name() {
        return "Pool";
    }

    public boolean isClosed() {
        return this.closed;
    }

    public abstract T createObject() throws PoolException;

    public void destroyObject(T object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T borrowObject() throws PoolException, InterruptedException {
        Pool pool = this;
        synchronized (pool) {
            long timeLimit = 0L;
            while (true) {
                Object object;
                if ((object = this.pollFirst()) != null) {
                    return (T)object;
                }
                if (this.closed) {
                    throw new PoolException(this.name() + " is closed");
                }
                if (this.createdCount < this.maxCount) {
                    ++this.createdCount;
                    break;
                }
                long currentTime = System.currentTimeMillis();
                if (timeLimit == 0L) {
                    timeLimit = currentTime + (long)this.timeout;
                } else if (currentTime >= timeLimit) {
                    ++this.timeouts;
                    throw new PoolException(this.name() + " borrowObject timed out");
                }
                ++this.waitingThreads;
                this.wait(timeLimit - currentTime);
                --this.waitingThreads;
            }
        }
        try {
            return this.createObject();
        }
        catch (Throwable e) {
            this.decreaseCount();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void returnObject(T object) {
        Pool pool = this;
        synchronized (pool) {
            if (!this.keepEmpty) {
                if (this.waitingThreads > 0) {
                    this.notify();
                }
                if (this.fifo) {
                    this.addLast(object);
                } else {
                    this.addFirst(object);
                }
                return;
            }
        }
        this.invalidateObject(object);
    }

    public final void invalidateObject(T object) {
        this.decreaseCount();
        this.destroyObject(object);
    }

    public final synchronized void invalidateAll() {
        for (Object object : this) {
            this.destroyObject(object);
        }
        this.createdCount -= this.size();
        this.clear();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initialize() {
        try {
            for (int i = 0; i < this.initialCount; ++i) {
                T object = this.createObject();
                Pool pool = this;
                synchronized (pool) {
                    this.addLast(object);
                    ++this.createdCount;
                    continue;
                }
            }
        }
        catch (PoolException poolException) {
            // empty catch block
        }
    }

    private synchronized void decreaseCount() {
        --this.createdCount;
        if (this.waitingThreads > 0) {
            this.notify();
        }
    }
}

