/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.Serializable;
import one.nio.os.perf.PerfCounter;
import one.nio.os.perf.PerfCounterGlobal;
import one.nio.os.perf.PerfOptionGlobalGroup;

public class PerfOption
implements Serializable {
    public static final PerfOption DISABLED = new PerfOption("DISABLED");
    public static final PerfOption INHERIT = new PerfOption("INHERIT");
    public static final PerfOption EXCLUDE_USER = new PerfOption("EXCLUDE_USER");
    public static final PerfOption EXCLUDE_KERNEL = new PerfOption("EXCLUDE_KERNEL");
    public static final PerfOption SAMPLE_IP = PerfOption.sample(1);
    public static final PerfOption SAMPLE_TID = PerfOption.sample(2);
    public static final PerfOption SAMPLE_TIME = PerfOption.sample(4);
    public static final PerfOption SAMPLE_ADDR = PerfOption.sample(8);
    public static final PerfOption SAMPLE_READ = PerfOption.sample(16);
    public static final PerfOption SAMPLE_CALLCHAIN = PerfOption.sample(32);
    public static final PerfOption SAMPLE_ID = PerfOption.sample(64);
    public static final PerfOption SAMPLE_CPU = PerfOption.sample(128);
    public static final PerfOption SAMPLE_PERIOD = PerfOption.sample(256);
    public static final PerfOption SAMPLE_STREAM_ID = PerfOption.sample(512);
    public static final PerfOption SAMPLE_RAW = PerfOption.sample(1024);
    public static final PerfOption SAMPLE_BRANCH_STACK = PerfOption.sample(2048);
    public static final PerfOption SAMPLE_REGS_USER = PerfOption.sample(4096);
    public static final PerfOption SAMPLE_STACK_USER = PerfOption.sample(8192);
    public static final PerfOption SAMPLE_WEIGHT = PerfOption.sample(16384);
    public static final PerfOption SAMPLE_DATA_SRC = PerfOption.sample(32768);
    public static final PerfOption SAMPLE_IDENTIFIER = PerfOption.sample(65536);
    public static final PerfOption SAMPLE_TRANSACTION = PerfOption.sample(131072);
    public static final PerfOption SAMPLE_REGS_INTR = PerfOption.sample(262144);
    public static final PerfOption SAMPLE_PHYS_ADD = PerfOption.sample(524288);
    public static final PerfOption FORMAT_GROUP = PerfOption.format(8);
    static final PerfOption PID_CGROUP = new PerfOption("PID_CGROUP");
    static final String GROUP_GLOBAL = "GROUP_GLOBAL";
    final String name;
    final long value;

    protected PerfOption(String name) {
        this.name = name;
        this.value = -1L;
    }

    protected PerfOption(String name, long value) {
        this.name = name;
        this.value = value;
    }

    public String toString() {
        return this.value < 0L ? this.name : this.name + '=' + this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof PerfOption) {
            PerfOption other = (PerfOption)o;
            return this.name.equals(other.name) && this.value == other.value;
        }
        return false;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public static PerfOption period(long value) {
        return new PerfOption("PERIOD", value);
    }

    public static PerfOption freq(long value) {
        return new PerfOption("FREQ", value);
    }

    public static PerfOption wakeupEvents(int value) {
        return new PerfOption("WAKEUP_EVENTS", value);
    }

    public static PerfOption wakeupBytes(int value) {
        return new PerfOption("WAKEUP_BYTES", value);
    }

    public static PerfOption sample(int sampleType) {
        return new PerfOption("SAMPLE", sampleType);
    }

    public static PerfOption format(int formatType) {
        return new PerfOption("FORMAT", formatType);
    }

    public static PerfOption pages(int pages) {
        return new PerfOption("PAGES", pages);
    }

    public static PerfOption group(PerfCounter leader) {
        return leader instanceof PerfCounterGlobal ? new PerfOptionGlobalGroup(GROUP_GLOBAL, ((PerfCounterGlobal)leader).fds) : new PerfOption("GROUP", leader.fd);
    }
}

