/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.bpf;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import one.nio.os.bpf.Bpf;
import one.nio.os.bpf.Handle;

public abstract class BpfObj
extends Handle {
    public static final int MAX_NAME_LEN = 15;
    public final int id;
    public final String name;

    public BpfObj(int id, String name, int fd) {
        super(fd);
        this.id = id;
        this.name = name;
    }

    public void pin(String path) throws IOException {
        Bpf.objectPin(this.fd(), path);
    }

    static class IdsIterator
    implements Iterator<Integer> {
        final int type;
        int next;
        boolean nextChecked;

        IdsIterator(int type) {
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            if (!this.nextChecked) {
                this.next = Bpf.objGetNextId(this.type, this.next);
                this.nextChecked = true;
            }
            return this.next > 0;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextChecked = false;
            return this.next;
        }
    }
}

