/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import one.nio.net.JavaDatagramSocket;
import one.nio.net.JavaServerSocket;
import one.nio.net.JavaSocket;
import one.nio.net.Msg;
import one.nio.net.NativeSocket;
import one.nio.net.SslContext;
import one.nio.net.SslOption;
import one.nio.os.NativeLibrary;

public abstract class Socket
implements ByteChannel {
    public static final int AF_UNIX = 1;
    public static final int AF_INET = 2;
    public static final int AF_INET6 = 10;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_RAW = 3;
    public static final int SOCK_RDM = 4;
    public static final int SOCK_SEQPACKET = 5;
    public static final int NO_PORT = -1;
    public static final int SOL_SOCKET = 1;
    public static final int SOL_IP = 0;
    public static final int SOL_IPV6 = 41;
    public static final int SOL_TCP = 6;
    public static final int SOL_UDP = 17;
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    public static final int MSG_TRUNC = 32;
    public static final int MSG_DONTWAIT = 64;
    public static final int MSG_WAITALL = 256;
    public static final int MSG_MORE = 32768;
    public static final int IPTOS_MINCOST = 2;
    public static final int IPTOS_RELIABILITY = 4;
    public static final int IPTOS_THROUGHPUT = 8;
    public static final int IPTOS_LOWDELAY = 16;
    public static final int SO_DEBUG = 1;
    public static final int SO_REUSEADDR = 2;
    public static final int SO_TYPE = 3;
    public static final int SO_ERROR = 4;
    public static final int SO_DONTROUTE = 5;
    public static final int SO_BROADCAST = 6;
    public static final int SO_SNDBUF = 7;
    public static final int SO_RCVBUF = 8;
    public static final int SO_KEEPALIVE = 9;
    public static final int SO_OOBINLINE = 10;
    public static final int SO_NO_CHECK = 11;
    public static final int SO_PRIORITY = 12;
    public static final int SO_LINGER = 13;
    public static final int SO_BSDCOMPAT = 14;
    public static final int SO_REUSEPORT = 15;
    public static final int SO_PASSCRED = 16;
    public static final int SO_PEERCRED = 17;
    public static final int SO_RCVLOWAT = 18;
    public static final int SO_SNDLOWAT = 19;
    public static final int SO_RCVTIMEO = 20;
    public static final int SO_SNDTIMEO = 21;
    public static final int TCP_NODELAY = 1;
    public static final int TCP_MAXSEG = 2;
    public static final int TCP_CORK = 3;
    public static final int TCP_KEEPIDLE = 4;
    public static final int TCP_KEEPINTVL = 5;
    public static final int TCP_KEEPCNT = 6;
    public static final int TCP_SYNCNT = 7;
    public static final int TCP_LINGER2 = 8;
    public static final int TCP_DEFER_ACCEPT = 9;
    public static final int TCP_WINDOW_CLAMP = 10;
    public static final int TCP_INFO = 11;
    public static final int TCP_QUICKACK = 12;
    public static final int TCP_CONGESTION = 13;
    public static final int TCP_USER_TIMEOUT = 18;

    @Override
    public abstract boolean isOpen();

    @Override
    public abstract void close();

    public abstract Socket accept() throws IOException;

    public abstract void connect(InetAddress var1, int var2) throws IOException;

    public abstract void bind(InetAddress var1, int var2, int var3) throws IOException;

    public abstract void listen(int var1) throws IOException;

    public abstract int writeRaw(long var1, int var3, int var4) throws IOException;

    public abstract int write(byte[] var1, int var2, int var3, int var4) throws IOException;

    public abstract void writeFully(byte[] var1, int var2, int var3) throws IOException;

    public abstract int send(ByteBuffer var1, int var2, InetAddress var3, int var4) throws IOException;

    public abstract int readRaw(long var1, int var3, int var4) throws IOException;

    public abstract int read(byte[] var1, int var2, int var3, int var4) throws IOException;

    public abstract void readFully(byte[] var1, int var2, int var3) throws IOException;

    public abstract InetSocketAddress recv(ByteBuffer var1, int var2) throws IOException;

    public abstract long sendFile(RandomAccessFile var1, long var2, long var4) throws IOException;

    public abstract int sendMsg(Msg var1, int var2) throws IOException;

    public abstract int recvMsg(Msg var1, int var2) throws IOException;

    public abstract void setBlocking(boolean var1);

    public abstract boolean isBlocking();

    public abstract void setTimeout(int var1);

    public abstract int getTimeout();

    public abstract void setKeepAlive(boolean var1);

    public abstract boolean getKeepAlive();

    public abstract void setNoDelay(boolean var1);

    public abstract boolean getNoDelay();

    public abstract void setTcpFastOpen(boolean var1);

    public abstract boolean getTcpFastOpen();

    public abstract void setDeferAccept(boolean var1);

    public abstract boolean getDeferAccept();

    public abstract void setReuseAddr(boolean var1, boolean var2);

    public abstract boolean getReuseAddr();

    public abstract boolean getReusePort();

    public abstract void setRecvBuffer(int var1);

    public abstract int getRecvBuffer();

    public abstract void setSendBuffer(int var1);

    public abstract int getSendBuffer();

    public abstract void setTos(int var1);

    public abstract int getTos();

    public abstract byte[] getOption(int var1, int var2);

    public abstract boolean setOption(int var1, int var2, byte[] var3);

    public abstract InetSocketAddress getLocalAddress();

    public abstract InetSocketAddress getRemoteAddress();

    public abstract Socket sslWrap(SslContext var1) throws IOException;

    public abstract Socket sslUnwrap();

    public abstract SslContext getSslContext();

    public abstract <T> T getSslOption(SslOption<T> var1);

    public Socket acceptNonBlocking() throws IOException {
        Socket s = this.accept();
        s.setBlocking(false);
        return s;
    }

    public void connect(String host, int port) throws IOException {
        this.connect(InetAddress.getByName(host), port);
    }

    public void bind(String host, int port, int backlog) throws IOException {
        this.bind(InetAddress.getByName(host), port, backlog);
    }

    public int send(ByteBuffer data, int flags, String host, int port) throws IOException {
        return this.send(data, flags, InetAddress.getByName(host), port);
    }

    public void handshake() throws IOException {
    }

    public int write(byte[] data, int offset, int count) throws IOException {
        return this.write(data, offset, count, 0);
    }

    public int read(byte[] data, int offset, int count) throws IOException {
        return this.read(data, offset, count, 0);
    }

    public static Socket create() throws IOException {
        return NativeLibrary.IS_SUPPORTED ? new NativeSocket(0, 1) : new JavaSocket();
    }

    public static Socket createServerSocket() throws IOException {
        return NativeLibrary.IS_SUPPORTED ? new NativeSocket(0, 1) : new JavaServerSocket();
    }

    public static Socket createDatagramSocket() throws IOException {
        return NativeLibrary.IS_SUPPORTED ? new NativeSocket(0, 2) : new JavaDatagramSocket();
    }

    public static Socket createUnixSocket(int type) throws IOException {
        if (!NativeLibrary.IS_SUPPORTED) {
            throw new IOException("Unix sockets are supported in native mode only");
        }
        return new NativeSocket(1, type);
    }

    public static Socket connectInet(InetAddress address, int port) throws IOException {
        Socket sock = Socket.create();
        sock.connect(address, port);
        return sock;
    }

    public static Socket bindInet(InetAddress address, int port, int backlog) throws IOException {
        Socket sock = Socket.createServerSocket();
        sock.bind(address, port, backlog);
        sock.listen(backlog);
        return sock;
    }

    public static Socket connectUnix(File unixPath) throws IOException {
        if (!NativeLibrary.IS_SUPPORTED) {
            throw new IOException("Unix sockets are supported in native mode only");
        }
        NativeSocket sock = new NativeSocket(1, 1);
        sock.connect(unixPath.getAbsolutePath(), -1);
        return sock;
    }

    public static Socket bindUnix(File unixPath, int backlog) throws IOException {
        if (!NativeLibrary.IS_SUPPORTED) {
            throw new IOException("Unix sockets are supported in native mode only");
        }
        NativeSocket sock = new NativeSocket(1, 1);
        sock.bind(unixPath.getAbsolutePath(), -1, backlog);
        sock.listen(backlog);
        return sock;
    }

    public static Socket fromFD(int fd) throws IOException {
        if (NativeLibrary.IS_SUPPORTED) {
            return new NativeSocket(fd);
        }
        throw new IOException("Operation is not supported");
    }
}

