/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import one.nio.net.Socket;
import one.nio.util.Utf8;

public class ProxyProtocol {
    private static final byte[] PROXY_PROTOCOL_START = Utf8.toBytes("PROXY TCP");
    private static final int MAX_PROXY_PROTOCOL_HEADER = 104;
    private static final int MIN_PROXY_PROTOCOL_HEADER = 22;

    public static InetSocketAddress parse(Socket socket, byte[] buffer) throws IOException {
        int dstIpStart;
        byte[] addr;
        Socket rawSocket = socket.sslUnwrap();
        int bytesRead = rawSocket.read(buffer, 0, 104, 2);
        int lineEnd = Utf8.indexOf((byte)10, buffer, 0, bytesRead) + 1;
        if (lineEnd < 22 || !Utf8.startsWith(PROXY_PROTOCOL_START, buffer, 0) || buffer[10] != 32) {
            return null;
        }
        if (buffer[9] == 52) {
            addr = new byte[4];
            dstIpStart = ProxyProtocol.parseIPv4(buffer, 11, addr);
        } else {
            addr = new byte[16];
            dstIpStart = ProxyProtocol.parseIPv6(buffer, 11, addr);
        }
        int dstIpEnd = Utf8.indexOf((byte)32, buffer, dstIpStart, lineEnd - dstIpStart);
        if (dstIpEnd <= dstIpStart) {
            return null;
        }
        int port = ProxyProtocol.parsePort(buffer, dstIpEnd + 1);
        rawSocket.read(buffer, 0, lineEnd, 32);
        return new InetSocketAddress(InetAddress.getByAddress(addr), port);
    }

    private static int parseIPv4(byte[] buffer, int offset, byte[] addr) {
        block3: {
            int pos = 0;
            int val = 0;
            while (true) {
                byte b;
                if ((b = buffer[offset++]) >= 48 && b <= 57) {
                    val = val * 10 + (b - 48);
                    continue;
                }
                if (b != (pos < 3 ? (byte)46 : 32) || val < 0 || val > 255) break;
                addr[pos++] = (byte)val;
                if (b != 32) {
                    val = 0;
                    continue;
                }
                break block3;
                break;
            }
            throw new IllegalArgumentException("Invalid IPv4 address");
        }
        return offset;
    }

    private static int parseIPv6(byte[] buffer, int offset, byte[] addr) {
        block5: {
            int pos = 0;
            int val = 0;
            while (true) {
                byte b;
                if ((b = buffer[offset++]) >= 48 && b <= 57) {
                    val = val * 16 + (b - 48);
                    continue;
                }
                if (b >= 97 && b <= 102) {
                    val = val * 16 + (b - 97);
                    continue;
                }
                if (b >= 65 && b <= 70) {
                    val = val * 16 + (b - 65);
                    continue;
                }
                if (b != (pos < 14 ? (byte)58 : 32) || val < 0 || val > 65535) break;
                addr[pos++] = (byte)(val >>> 8);
                addr[pos++] = (byte)val;
                if (b != 32) {
                    val = 0;
                    continue;
                }
                break block5;
                break;
            }
            throw new IllegalArgumentException("Invalid IPv6 address");
        }
        return offset;
    }

    private static int parsePort(byte[] buffer, int offset) {
        byte b;
        int port = 0;
        while ((b = buffer[offset++]) >= 48 && b <= 57) {
            port = port * 10 + (b - 48);
        }
        if (b == 32 && port >= 0 && port <= 65535) {
            return port;
        }
        throw new IllegalArgumentException("Invalid port");
    }
}

