/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.io.IOException;
import one.nio.mem.FixedSizeAllocator;
import one.nio.mem.SharedMemoryMap;

public abstract class SharedMemoryFixedMap<K, V>
extends SharedMemoryMap<K, V> {
    protected static final long ALLOCATOR_SIZE_OFFSET = 40L;
    protected static final long ALLOCATOR_HEAD_OFFSET = 48L;
    protected final int valueSize;
    protected final FixedSizeAllocator allocator;

    protected SharedMemoryFixedMap(String fileName, long fileSize, int valueSize) throws IOException {
        this(fileName, fileSize, valueSize, 0L);
    }

    protected SharedMemoryFixedMap(String fileName, long fileSize, int valueSize, long expirationTime) throws IOException {
        this((int)((double)(fileSize / (long)SharedMemoryFixedMap.getEntrySize(valueSize)) * 1.5), fileName, fileSize, valueSize, expirationTime);
    }

    protected SharedMemoryFixedMap(int capacity, String fileName, long fileSize, int valueSize, long expirationTime) throws IOException {
        super(capacity, fileName, fileSize, expirationTime);
        this.valueSize = valueSize;
        this.allocator = this.createFixedSizeAllocator(SharedMemoryFixedMap.getEntrySize(valueSize));
    }

    protected static int getEntrySize(int valueSize) {
        return valueSize + 31 & 0xFFFFFFF8;
    }

    private FixedSizeAllocator createFixedSizeAllocator(int entrySize) {
        long allocOffset = 0x100000L + (long)this.capacity * 8L;
        long allocBase = this.mmap.getAddr() + allocOffset;
        long allocSize = this.mmap.getSize() - allocOffset;
        long oldEntrySize = this.getHeader(40L);
        if (oldEntrySize == 0L) {
            return new FixedSizeAllocator(allocBase, allocSize, entrySize);
        }
        if (oldEntrySize == (long)entrySize) {
            return new FixedSizeAllocator(allocBase, allocSize, entrySize, this.getHeader(48L));
        }
        throw new IllegalArgumentException("Entry size has changed from " + oldEntrySize + " to " + entrySize);
    }

    @Override
    protected void closeInternal() {
        this.setHeader(40L, this.allocator.entrySize);
        this.setHeader(48L, this.allocator.head);
        super.closeInternal();
    }

    @Override
    protected void createAllocator(long startAddress, long totalMemory) {
    }

    @Override
    protected void loadSchema() {
    }

    @Override
    protected void storeSchema() {
    }

    @Override
    protected void relocate(long delta) {
        super.relocate(delta);
        FixedSizeAllocator.relocate(this.mmap.getAddr() + 48L, delta);
    }

    @Override
    protected long allocateEntry(K key, long hashCode, int size) {
        return this.allocator.malloc();
    }

    @Override
    protected void destroyEntry(long entry) {
        this.allocator.free(entry);
    }

    @Override
    protected int sizeOf(long entry) {
        return 0;
    }

    @Override
    protected int sizeOf(V value) {
        return 0;
    }

    @Override
    public long getTotalMemory() {
        return this.allocator.totalMemory();
    }

    @Override
    public long getFreeMemory() {
        return this.getTotalMemory() - this.getUsedMemory();
    }

    @Override
    public long getUsedMemory() {
        return this.allocator.usedMemory();
    }
}

