/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import one.nio.mem.DirectMemory;
import one.nio.mem.OffheapMap;
import one.nio.util.Hash;

public class OffheapBlobMap
extends OffheapMap<byte[], byte[]> {
    protected static final int KEY_OFFSET = 28;

    public OffheapBlobMap(int capacity) {
        super(capacity, 0L);
    }

    @Override
    public byte[] keyAt(long entry) {
        int keyLength = (int)(unsafe.getLong(entry + 0L) >>> 32);
        byte[] key = new byte[keyLength];
        unsafe.copyMemory(null, entry + 28L, key, byteArrayOffset, keyLength);
        return key;
    }

    @Override
    protected long hashCode(byte[] key) {
        int xxhash = Hash.xxhash((Object)key, byteArrayOffset, key.length);
        return (long)key.length << 32 | (long)xxhash & 0xFFFFFFFFL;
    }

    @Override
    protected boolean equalsAt(long entry, byte[] key) {
        return DirectMemory.compare(null, entry + 28L, key, byteArrayOffset, key.length);
    }

    @Override
    protected byte[] valueAt(long entry) {
        int keyLength = (int)(unsafe.getLong(entry + 0L) >>> 32);
        int valueLength = this.sizeOf(entry);
        byte[] value = new byte[valueLength];
        unsafe.copyMemory(null, entry + 28L + (long)keyLength, value, byteArrayOffset, valueLength);
        return value;
    }

    @Override
    protected void setValueAt(long entry, byte[] value) {
        int keyLength = (int)(unsafe.getLong(entry + 0L) >>> 32);
        int valueLength = value.length;
        unsafe.putInt(entry + 24L, valueLength);
        unsafe.copyMemory(value, byteArrayOffset, null, entry + 28L + (long)keyLength, valueLength);
    }

    @Override
    protected long allocateEntry(byte[] key, long hashCode, int size) {
        long entry = unsafe.allocateMemory(28 + key.length + size);
        unsafe.copyMemory(key, byteArrayOffset, null, entry + 28L, key.length);
        return entry;
    }

    @Override
    protected void destroyEntry(long entry) {
        unsafe.freeMemory(entry);
    }

    @Override
    protected int sizeOf(long entry) {
        return unsafe.getInt(entry + 24L);
    }

    @Override
    protected int sizeOf(byte[] value) {
        return value.length;
    }
}

