/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.io.PrintStream;
import java.util.Arrays;
import one.nio.mem.Malloc;
import one.nio.mem.MallocMT;
import one.nio.mem.MappedFile;
import one.nio.util.JavaInternals;

public class MallocAnalyzer
extends MallocMT {
    private PrintStream out;

    public MallocAnalyzer(long base, long capacity, PrintStream out) {
        super(base, capacity);
        this.out = out;
    }

    public void info() {
        this.segmentInfo();
        this.chunkInfo();
    }

    public void segmentInfo() {
        this.out.println("=== Segment Info ===");
        this.out.println("Segment #\tBase\tTotal\tUsed\tFree");
        for (int i = 0; i < this.segments(); ++i) {
            Malloc segment = this.segment(i);
            this.out.println("Segment " + i + "\t" + Long.toHexString(segment.base) + "\t" + segment.getTotalMemory() + "\t" + segment.getUsedMemory() + "\t" + segment.getFreeMemory());
        }
        this.out.println("Total\t" + Long.toHexString(this.base) + "\t" + this.getTotalMemory() + "\t" + this.getUsedMemory() + "\t" + this.getFreeMemory());
        this.out.println();
    }

    public void chunkInfo() {
        BinStats[] usedStats = new BinStats[this.segments()];
        BinStats[] freeStats = new BinStats[this.segments()];
        BinStats[] altStats = new BinStats[this.segments()];
        for (int i = 0; i < this.segments(); ++i) {
            int size;
            long end = this.segment((int)i).base + this.segment((int)i).capacity - 16L;
            BinStats used = usedStats[i] = new BinStats();
            BinStats free = freeStats[i] = new BinStats();
            for (long start = this.segment((int)i).base + 1024L; start < end; start += (long)size) {
                int sizeField = JavaInternals.unsafe.getInt(start + 0L);
                (sizeField == (size = sizeField & 0x7FFFFFF8) ? free : used).addChunk(size);
            }
            BinStats alt = altStats[i] = new BinStats();
            for (int bin = MallocAnalyzer.getBin(24); bin < 120; ++bin) {
                long chunk = this.segment((int)i).base + (long)(bin * 8);
                while ((chunk = JavaInternals.unsafe.getLong(chunk + 8L)) != 0L) {
                    int size2 = JavaInternals.unsafe.getInt(chunk + 0L) & 0x7FFFFFF8;
                    alt.addChunk(bin, size2);
                }
            }
        }
        this.printChunkInfo("=== Used Info ===", usedStats);
        this.printChunkInfo("=== Free Info ===", freeStats);
        this.printChunkInfo("=== AltFree Info ===", altStats);
    }

    private void printChunkInfo(String header, BinStats[] stats) {
        this.out.println(header);
        long globalCounter = 0L;
        long globalTotal = 0L;
        for (int bin = MallocAnalyzer.getBin(24); bin < 120; ++bin) {
            this.out.print("Bin " + bin + "\t" + ((long)MallocAnalyzer.binSize(bin) & 0xFFFFFFFFL));
            int counter = 0;
            long total = 0L;
            for (int i = 0; i < this.segments(); ++i) {
                this.out.print("\t" + stats[i].counter[bin]);
                counter += stats[i].counter[bin];
                total += stats[i].total[bin];
            }
            globalCounter += (long)counter;
            globalTotal += total;
            if (counter != 0) {
                this.out.println("\t" + counter + "\t" + total + "\t(" + total / (long)counter + ")");
                continue;
            }
            this.out.println();
        }
        if (globalCounter != 0L) {
            this.out.println("Total\t" + globalCounter + "\t" + globalTotal + "\t(" + globalTotal / globalCounter + ")");
        }
        this.out.println();
    }

    public static void main(String[] args) throws Exception {
        long shmMask;
        MappedFile mmap = new MappedFile(args[0], 0L, 2);
        long base = mmap.getAddr();
        long size = mmap.getSize();
        long signature = JavaInternals.unsafe.getLong(base);
        if ((signature & (shmMask = -6843186338122078093L)) == shmMask) {
            long capacity = JavaInternals.unsafe.getLong(base + 16L);
            long offset = 0x100000L + capacity * 8L;
            base += offset;
            size -= offset;
        } else if (signature == -6917164749395498893L || signature == -6917154901035489165L) {
            long offset = JavaInternals.unsafe.getLong(base + 16L);
            base += offset;
            size -= offset;
        }
        MallocAnalyzer ma = new MallocAnalyzer(base, size, System.out);
        ma.info();
        mmap.close();
    }

    static class BinStats {
        final int[] counter = new int[120];
        final long[] total = new long[120];
        final int[] min = new int[120];
        final int[] max = new int[120];

        BinStats() {
            Arrays.fill(this.min, Integer.MAX_VALUE);
        }

        void addChunk(int size) {
            this.addChunk(Malloc.chooseBin(size), size);
        }

        void addChunk(int bin, int size) {
            int n = bin;
            this.counter[n] = this.counter[n] + 1;
            int n2 = bin;
            this.total[n2] = this.total[n2] + (long)(size -= 8);
            if (size < this.min[bin]) {
                this.min[bin] = size;
            }
            if (size > this.max[bin]) {
                this.max[bin] = size;
            }
        }
    }
}

