/*
 * Decompiled with CFR 0.152.
 */
package one.nio.lz4;

import java.nio.ByteBuffer;
import one.nio.mem.DirectMemory;
import one.nio.os.NativeLibrary;
import one.nio.util.JavaInternals;

public class LZ4 {
    private static final int LZ4_MAX_INPUT_SIZE = 0x7E000000;
    private static final int LZ4_MEMORY_USAGE = 15;
    private static final int ACCELERATION = 1;
    private static final int MINMATCH = 4;
    private static final int COPYLENGTH = 8;
    private static final int LASTLITERALS = 5;
    private static final int MFLIMIT = 12;
    private static final int LZ4_MIN_LENGTH = 13;
    private static final int MAXD_LOG = 16;
    private static final int MAX_DISTANCE = 65535;
    private static final int ML_BITS = 4;
    private static final int ML_MASK = 15;
    private static final int RUN_BITS = 4;
    private static final int RUN_MASK = 15;
    private static final int HASH_SIZE_16 = 16384;
    private static final int HASH_SIZE_32 = 8192;
    private static final int LZ4_SKIP_TRIGGER = 6;
    private static final int LZ4_64K_LIMIT = 65547;
    private static final long DEC64_TABLE = 216736835857022976L;
    private static final long DEC32_TABLE = 289360691301843204L;

    public static int compressBound(int size) {
        return size + size / 255 + 16;
    }

    public static int compress(byte[] src, byte[] dst) {
        return LZ4.compress(src, 0, dst, 0, src.length);
    }

    public static int compress(byte[] src, int srcOffset, byte[] dst, int dstOffset, int length) {
        if (srcOffset < 0 || srcOffset + length > src.length || dstOffset < 0 || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (LZ4.compressBound(length) > dst.length - dstOffset) {
            throw new IllegalArgumentException("Output array is too small");
        }
        if (NativeLibrary.IS_SUPPORTED) {
            return LZ4.compress0(src, srcOffset, dst, dstOffset, length);
        }
        if (length < 65547) {
            return LZ4.compress16(src, JavaInternals.byteArrayOffset + (long)srcOffset, dst, JavaInternals.byteArrayOffset + (long)dstOffset, length);
        }
        if (length <= 0x7E000000) {
            return LZ4.compress32(src, JavaInternals.byteArrayOffset + (long)srcOffset, dst, JavaInternals.byteArrayOffset + (long)dstOffset, length);
        }
        throw new IllegalArgumentException("Input exceeds limit");
    }

    public static int compress(ByteBuffer src, ByteBuffer dst) {
        int result;
        int length = src.remaining();
        if (LZ4.compressBound(length) > dst.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        if (NativeLibrary.IS_SUPPORTED) {
            result = LZ4.compress0(LZ4.array(src), LZ4.offset(src), LZ4.array(dst), LZ4.offset(dst), length);
        } else if (length < 65547) {
            result = LZ4.compress16(LZ4.array(src), LZ4.address(src), LZ4.array(dst), LZ4.address(dst), length);
        } else if (length <= 0x7E000000) {
            result = LZ4.compress32(LZ4.array(src), LZ4.address(src), LZ4.array(dst), LZ4.address(dst), length);
        } else {
            throw new IllegalArgumentException("Input exceeds limit");
        }
        src.position(src.limit());
        dst.position(dst.position() + result);
        return result;
    }

    public static int decompress(byte[] src, byte[] dst) {
        return LZ4.decompress(src, 0, dst, 0, src.length);
    }

    public static int decompress(byte[] src, int srcOffset, byte[] dst, int dstOffset, int length) {
        if (srcOffset < 0 || srcOffset + length > src.length || dstOffset < 0 || length <= 0) {
            throw new IndexOutOfBoundsException();
        }
        int result = NativeLibrary.IS_SUPPORTED ? LZ4.decompress0(src, srcOffset, dst, dstOffset, length, dst.length - dstOffset) : LZ4.decompress(src, JavaInternals.byteArrayOffset + (long)srcOffset, dst, JavaInternals.byteArrayOffset + (long)dstOffset, length, dst.length - dstOffset);
        if (result < 0) {
            throw new IllegalArgumentException("Malformed input");
        }
        return result;
    }

    public static int decompress(ByteBuffer src, ByteBuffer dst) {
        int result = NativeLibrary.IS_SUPPORTED ? LZ4.decompress0(LZ4.array(src), LZ4.offset(src), LZ4.array(dst), LZ4.offset(dst), src.remaining(), dst.remaining()) : LZ4.decompress(LZ4.array(src), LZ4.address(src), LZ4.array(dst), LZ4.address(dst), src.remaining(), dst.remaining());
        if (result < 0) {
            throw new IllegalArgumentException("Malformed input");
        }
        src.position(src.limit());
        dst.position(dst.position() + result);
        return result;
    }

    private static byte[] array(ByteBuffer buf) {
        return buf.hasArray() ? buf.array() : null;
    }

    private static long offset(ByteBuffer buf) {
        return (buf.hasArray() ? (long)buf.arrayOffset() : DirectMemory.getAddress(buf)) + (long)buf.position();
    }

    private static long address(ByteBuffer buf) {
        return (buf.hasArray() ? JavaInternals.byteArrayOffset + (long)buf.arrayOffset() : DirectMemory.getAddress(buf)) + (long)buf.position();
    }

    private static int hashPosition16(Object src, long p) {
        long sequence = JavaInternals.unsafe.getLong(src, p);
        return (int)(sequence * 889523592379L >>> 26) & 0x3FFF;
    }

    private static int hashPosition32(Object src, long p) {
        long sequence = JavaInternals.unsafe.getLong(src, p);
        return (int)(sequence * 889523592379L >>> 27) & 0x1FFF;
    }

    private static void putPosition(short[] table, long p, Object src, long srcOffset) {
        int h = LZ4.hashPosition16(src, p);
        table[h] = (short)(p - srcOffset);
    }

    private static long replacePosition(short[] table, long p, Object src, long srcOffset) {
        int h = LZ4.hashPosition16(src, p);
        long prev = ((long)table[h] & 0xFFFFL) + srcOffset;
        table[h] = (short)(p - srcOffset);
        return prev;
    }

    private static void putPosition(int[] table, long p, Object src, long srcOffset) {
        int h = LZ4.hashPosition32(src, p);
        table[h] = (int)(p - srcOffset);
    }

    private static long replacePosition(int[] table, long p, Object src, long srcOffset) {
        int h = LZ4.hashPosition32(src, p);
        long prev = ((long)table[h] & 0xFFFFFFFFL) + srcOffset;
        table[h] = (int)(p - srcOffset);
        return prev;
    }

    private static int matchLength(Object src, long pIn, long pMatch, long pInLimit) {
        long pStart = pIn;
        while (pIn < pInLimit - 7L) {
            long diff = JavaInternals.unsafe.getLong(src, pMatch) ^ JavaInternals.unsafe.getLong(src, pIn);
            if (diff != 0L) {
                return (int)((pIn += (long)(Long.numberOfTrailingZeros(diff) >>> 3)) - pStart);
            }
            pIn += 8L;
            pMatch += 8L;
        }
        if (pIn < pInLimit - 3L && JavaInternals.unsafe.getInt(src, pMatch) == JavaInternals.unsafe.getInt(src, pIn)) {
            pIn += 4L;
            pMatch += 4L;
        }
        if (pIn < pInLimit - 1L && JavaInternals.unsafe.getShort(src, pMatch) == JavaInternals.unsafe.getShort(src, pIn)) {
            pIn += 2L;
            pMatch += 2L;
        }
        if (pIn < pInLimit && JavaInternals.unsafe.getByte(src, pMatch) == JavaInternals.unsafe.getByte(src, pIn)) {
            ++pIn;
        }
        return (int)(pIn - pStart);
    }

    private static void wildCopy(Object src, long srcOffset, Object dst, long dstOffset, long dstEnd) {
        do {
            JavaInternals.unsafe.putLong(dst, dstOffset, JavaInternals.unsafe.getLong(src, srcOffset));
            srcOffset += 8L;
        } while ((dstOffset += 8L) < dstEnd);
    }

    private static int compress16(Object src, long srcOffset, Object dst, long dstOffset, int inputSize) {
        int lastRun;
        long srcEnd = srcOffset + (long)inputSize;
        long mfLimit = srcEnd - 12L;
        long matchLimit = srcEnd - 5L;
        long ip = srcOffset;
        long anchor = srcOffset;
        long op = dstOffset;
        if (inputSize >= 13) {
            short[] table = new short[16384];
            LZ4.putPosition(table, ip, src, srcOffset);
            int forwardH = LZ4.hashPosition16(src, ++ip);
            block0: while (true) {
                long token;
                long match;
                long forwardIp = ip;
                int step = 1;
                int searchMatchNb = 64;
                do {
                    int h = forwardH;
                    ip = forwardIp;
                    if ((forwardIp += (long)(step = searchMatchNb++ >>> 6)) > mfLimit) break block0;
                    forwardH = LZ4.hashPosition16(src, forwardIp);
                    table[h] = (short)(ip - srcOffset);
                } while (JavaInternals.unsafe.getInt(src, match) != JavaInternals.unsafe.getInt(src, ip));
                for (match = ((long)table[h] & 0xFFFFL) + srcOffset; ip > anchor && match > srcOffset && JavaInternals.unsafe.getByte(src, ip - 1L) == JavaInternals.unsafe.getByte(src, match - 1L); --ip, --match) {
                }
                int litLength = (int)(ip - anchor);
                ++op;
                if (litLength >= 15) {
                    int len;
                    JavaInternals.unsafe.putByte(dst, token, (byte)-16);
                    for (len = litLength - 15; len >= 255; len -= 255) {
                        JavaInternals.unsafe.putByte(dst, op++, (byte)-1);
                    }
                    JavaInternals.unsafe.putByte(dst, op++, (byte)len);
                } else {
                    JavaInternals.unsafe.putByte(dst, token, (byte)(litLength << 4));
                }
                LZ4.wildCopy(src, anchor, dst, op, op + (long)litLength);
                op += (long)litLength;
                while (true) {
                    JavaInternals.unsafe.putShort(dst, op, (short)(ip - match));
                    op += 2L;
                    int matchLength = LZ4.matchLength(src, ip + 4L, match + 4L, matchLimit);
                    ip += (long)(4 + matchLength);
                    if (matchLength >= 15) {
                        JavaInternals.unsafe.putByte(dst, token, (byte)(JavaInternals.unsafe.getByte(dst, token) + 15));
                        matchLength -= 15;
                        while (matchLength >= 510) {
                            JavaInternals.unsafe.putShort(dst, op, (short)-1);
                            op += 2L;
                            matchLength -= 510;
                        }
                        if (matchLength >= 255) {
                            matchLength -= 255;
                            JavaInternals.unsafe.putByte(dst, op++, (byte)-1);
                        }
                        JavaInternals.unsafe.putByte(dst, op++, (byte)matchLength);
                    } else {
                        JavaInternals.unsafe.putByte(dst, token, (byte)(JavaInternals.unsafe.getByte(dst, token) + matchLength));
                    }
                    anchor = ip;
                    if (ip > mfLimit) break block0;
                    LZ4.putPosition(table, ip - 2L, src, srcOffset);
                    match = LZ4.replacePosition(table, ip, src, srcOffset);
                    if (match + 65535L < ip || JavaInternals.unsafe.getInt(src, match) != JavaInternals.unsafe.getInt(src, ip)) break;
                    ++op;
                    JavaInternals.unsafe.putByte(dst, token, (byte)0);
                }
                forwardH = LZ4.hashPosition16(src, ++ip);
            }
        }
        if ((lastRun = (int)(srcEnd - anchor)) >= 15) {
            int accumulator;
            JavaInternals.unsafe.putByte(dst, op++, (byte)-16);
            for (accumulator = lastRun - 15; accumulator >= 255; accumulator -= 255) {
                JavaInternals.unsafe.putByte(dst, op++, (byte)-1);
            }
            JavaInternals.unsafe.putByte(dst, op++, (byte)accumulator);
        } else {
            JavaInternals.unsafe.putByte(dst, op++, (byte)(lastRun << 4));
        }
        JavaInternals.unsafe.copyMemory(src, anchor, dst, op, lastRun);
        return (int)((op += (long)lastRun) - dstOffset);
    }

    private static int compress32(Object src, long srcOffset, Object dst, long dstOffset, int inputSize) {
        int lastRun;
        long srcEnd = srcOffset + (long)inputSize;
        long mfLimit = srcEnd - 12L;
        long matchLimit = srcEnd - 5L;
        long ip = srcOffset;
        long anchor = srcOffset;
        long op = dstOffset;
        if (inputSize >= 13) {
            int[] table = new int[8192];
            LZ4.putPosition(table, ip, src, srcOffset);
            int forwardH = LZ4.hashPosition32(src, ++ip);
            block0: while (true) {
                long token;
                long match;
                long forwardIp = ip;
                int step = 1;
                int searchMatchNb = 64;
                do {
                    int h = forwardH;
                    ip = forwardIp;
                    if ((forwardIp += (long)(step = searchMatchNb++ >>> 6)) > mfLimit) break block0;
                    forwardH = LZ4.hashPosition32(src, forwardIp);
                    table[h] = (int)(ip - srcOffset);
                } while (match + 65535L < ip || JavaInternals.unsafe.getInt(src, match) != JavaInternals.unsafe.getInt(src, ip));
                for (match = ((long)table[h] & 0xFFFFFFFFL) + srcOffset; ip > anchor && match > srcOffset && JavaInternals.unsafe.getByte(src, ip - 1L) == JavaInternals.unsafe.getByte(src, match - 1L); --ip, --match) {
                }
                int litLength = (int)(ip - anchor);
                ++op;
                if (litLength >= 15) {
                    int len;
                    JavaInternals.unsafe.putByte(dst, token, (byte)-16);
                    for (len = litLength - 15; len >= 255; len -= 255) {
                        JavaInternals.unsafe.putByte(dst, op++, (byte)-1);
                    }
                    JavaInternals.unsafe.putByte(dst, op++, (byte)len);
                } else {
                    JavaInternals.unsafe.putByte(dst, token, (byte)(litLength << 4));
                }
                LZ4.wildCopy(src, anchor, dst, op, op + (long)litLength);
                op += (long)litLength;
                while (true) {
                    JavaInternals.unsafe.putShort(dst, op, (short)(ip - match));
                    op += 2L;
                    int matchLength = LZ4.matchLength(src, ip + 4L, match + 4L, matchLimit);
                    ip += (long)(4 + matchLength);
                    if (matchLength >= 15) {
                        JavaInternals.unsafe.putByte(dst, token, (byte)(JavaInternals.unsafe.getByte(dst, token) + 15));
                        matchLength -= 15;
                        while (matchLength >= 510) {
                            JavaInternals.unsafe.putShort(dst, op, (short)-1);
                            op += 2L;
                            matchLength -= 510;
                        }
                        if (matchLength >= 255) {
                            matchLength -= 255;
                            JavaInternals.unsafe.putByte(dst, op++, (byte)-1);
                        }
                        JavaInternals.unsafe.putByte(dst, op++, (byte)matchLength);
                    } else {
                        JavaInternals.unsafe.putByte(dst, token, (byte)(JavaInternals.unsafe.getByte(dst, token) + matchLength));
                    }
                    anchor = ip;
                    if (ip > mfLimit) break block0;
                    LZ4.putPosition(table, ip - 2L, src, srcOffset);
                    match = LZ4.replacePosition(table, ip, src, srcOffset);
                    if (match + 65535L < ip || JavaInternals.unsafe.getInt(src, match) != JavaInternals.unsafe.getInt(src, ip)) break;
                    ++op;
                    JavaInternals.unsafe.putByte(dst, token, (byte)0);
                }
                forwardH = LZ4.hashPosition32(src, ++ip);
            }
        }
        if ((lastRun = (int)(srcEnd - anchor)) >= 15) {
            int accumulator;
            JavaInternals.unsafe.putByte(dst, op++, (byte)-16);
            for (accumulator = lastRun - 15; accumulator >= 255; accumulator -= 255) {
                JavaInternals.unsafe.putByte(dst, op++, (byte)-1);
            }
            JavaInternals.unsafe.putByte(dst, op++, (byte)accumulator);
        } else {
            JavaInternals.unsafe.putByte(dst, op++, (byte)(lastRun << 4));
        }
        JavaInternals.unsafe.copyMemory(src, anchor, dst, op, lastRun);
        return (int)((op += (long)lastRun) - dstOffset);
    }

    private static int decompress(Object src, long srcOffset, Object dst, long dstOffset, int inputSize, int outputSize) {
        long srcEnd = srcOffset + (long)inputSize;
        long dstEnd = dstOffset + (long)outputSize;
        long ip = srcOffset;
        long op = dstOffset;
        if (outputSize == 0) {
            return inputSize == 1 && JavaInternals.unsafe.getByte(src, ip) == 0 ? 0 : -1;
        }
        while (true) {
            long cpy;
            int token;
            int length;
            if ((length = (token = JavaInternals.unsafe.getByte(src, ip++) & 0xFF) >>> 4) == 15) {
                int s;
                do {
                    s = JavaInternals.unsafe.getByte(src, ip++) & 0xFF;
                    length += s;
                } while (ip < srcEnd - 15L && s == 255);
                if (length < 0) {
                    return -1;
                }
            }
            if ((cpy = op + (long)length) > dstEnd - 12L || ip + (long)length > srcEnd - 8L) {
                if (ip + (long)length != srcEnd || cpy > dstEnd) {
                    return -1;
                }
                JavaInternals.unsafe.copyMemory(src, ip, dst, op, length);
                return (int)((op += (long)length) - dstOffset);
            }
            LZ4.wildCopy(src, ip, dst, op, cpy);
            op = cpy;
            long match = cpy - (long)(JavaInternals.unsafe.getShort(src, ip += (long)length) & 0xFFFF);
            ip += 2L;
            if (match < dstOffset) {
                return -1;
            }
            length = token & 0xF;
            if (length == 15) {
                int s;
                do {
                    if (ip > srcEnd - 5L) {
                        return -1;
                    }
                    s = JavaInternals.unsafe.getByte(src, ip++) & 0xFF;
                    length += s;
                } while (s == 255);
                if (length < 0) {
                    return -1;
                }
            }
            cpy = op + (long)(length += 4);
            if (op - match < 8L) {
                byte dec64 = (byte)(216736835857022976L >>> (int)((op - match) * 8L));
                JavaInternals.unsafe.putByte(dst, op, JavaInternals.unsafe.getByte(dst, match));
                JavaInternals.unsafe.putByte(dst, op + 1L, JavaInternals.unsafe.getByte(dst, match + 1L));
                JavaInternals.unsafe.putByte(dst, op + 2L, JavaInternals.unsafe.getByte(dst, match + 2L));
                JavaInternals.unsafe.putByte(dst, op + 3L, JavaInternals.unsafe.getByte(dst, match + 3L));
                match += (long)((byte)(289360691301843204L >>> (int)((op - match) * 8L)));
                JavaInternals.unsafe.putInt(dst, op + 4L, JavaInternals.unsafe.getInt(dst, match));
                op += 8L;
                match -= (long)dec64;
            } else {
                JavaInternals.unsafe.putLong(dst, op, JavaInternals.unsafe.getLong(dst, match));
                op += 8L;
                match += 8L;
            }
            if (cpy > dstEnd - 12L) {
                if (cpy > dstEnd - 5L) {
                    return -1;
                }
                if (op < dstEnd - 8L) {
                    LZ4.wildCopy(dst, match, dst, op, dstEnd - 8L);
                    match += dstEnd - 8L - op;
                    op = dstEnd - 8L;
                }
                while (op < cpy) {
                    JavaInternals.unsafe.putByte(dst, op++, JavaInternals.unsafe.getByte(dst, match++));
                }
            } else {
                LZ4.wildCopy(dst, match, dst, op, cpy);
            }
            op = cpy;
        }
    }

    private static native int compress0(byte[] var0, long var1, byte[] var3, long var4, int var6);

    private static native int decompress0(byte[] var0, long var1, byte[] var3, long var4, int var6, int var7);
}

