/*
 * Decompiled with CFR 0.152.
 */
package one.nio.lock;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class RWLock
extends AbstractQueuedSynchronizer {
    private static final int READ = 1;
    private static final int WRITE = 65535;
    private static final long MILLIS = 1000000L;

    public RWLock() {
        this.setState(65535);
    }

    public final RWLock lockRead() {
        super.acquireShared(1);
        return this;
    }

    public final boolean lockRead(long timeout) {
        try {
            return super.tryAcquireSharedNanos(1, timeout * 1000000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final void unlockRead() {
        super.releaseShared(1);
    }

    public final RWLock lockWrite() {
        super.acquireShared(65535);
        return this;
    }

    public final boolean lockWrite(long timeout) {
        try {
            return super.tryAcquireSharedNanos(65535, timeout * 1000000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final void unlockWrite() {
        super.releaseShared(65535);
    }

    public final void unlock(boolean write) {
        super.releaseShared(write ? 65535 : 1);
    }

    public final void downgrade() {
        super.releaseShared(65534);
    }

    @Override
    protected int tryAcquireShared(int acquires) {
        int state;
        int remaining;
        while ((remaining = (state = this.getState()) - acquires) >= 0 && !this.compareAndSetState(state, remaining)) {
        }
        return remaining;
    }

    @Override
    protected final boolean tryReleaseShared(int releases) {
        int remaining;
        int state;
        while (!this.compareAndSetState(state = this.getState(), remaining = state + releases)) {
        }
        return true;
    }
}

