/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class HttpDate
extends GregorianCalendar {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String[] DAYS = new String[]{null, "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private final char[] chars = "Thu, 01 Jan 1970 00:00:00 GMT".toCharArray();

    public HttpDate() {
        super(GMT, Locale.US);
    }

    public char[] toCharArray() {
        return this.chars;
    }

    @Override
    public String toString() {
        return new String(this.chars);
    }

    public void setTime(long time) {
        super.setTimeInMillis(time);
        DAYS[this.fields[7]].getChars(0, 3, this.chars, 0);
        MONTHS[this.fields[2]].getChars(0, 3, this.chars, 8);
        this.setField(5, this.fields[5]);
        this.setField(12, this.fields[1] / 100);
        this.setField(14, this.fields[1] % 100);
        this.setField(17, this.fields[11]);
        this.setField(20, this.fields[12]);
        this.setField(23, this.fields[13]);
    }

    private void setField(int pos, int value) {
        this.chars[pos] = (char)(48 + value / 10);
        this.chars[pos + 1] = (char)(48 + value % 10);
    }
}

