/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectOutput;
import one.nio.serial.Repository;
import one.nio.serial.SerializationContext;
import one.nio.serial.Serializer;
import one.nio.util.Utf8;

public class CalcSizeStream
extends SerializationContext
implements ObjectOutput {
    protected int count;
    protected boolean hasCycles;

    public CalcSizeStream() {
    }

    public CalcSizeStream(int capacity) {
        super(capacity);
    }

    public int count() {
        return this.count;
    }

    public boolean hasCycles() {
        return this.hasCycles;
    }

    public void add(int constant) {
        this.count += constant;
    }

    @Override
    public void write(int b) {
        ++this.count;
    }

    @Override
    public void write(byte[] b) {
        this.count += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.count += len;
    }

    @Override
    public void writeBoolean(boolean v) {
        ++this.count;
    }

    @Override
    public void writeByte(int v) {
        ++this.count;
    }

    @Override
    public void writeShort(int v) {
        this.count += 2;
    }

    @Override
    public void writeChar(int v) {
        this.count += 2;
    }

    @Override
    public void writeInt(int v) {
        this.count += 4;
    }

    @Override
    public void writeLong(long v) {
        this.count += 8;
    }

    @Override
    public void writeFloat(float v) {
        this.count += 4;
    }

    @Override
    public void writeDouble(double v) {
        this.count += 8;
    }

    @Override
    public void writeBytes(String s) {
        this.count += s.length();
    }

    @Override
    public void writeChars(String s) {
        this.count += s.length() * 2;
    }

    @Override
    public void writeUTF(String s) {
        int length;
        this.count += length + ((length = Utf8.length(s)) <= Short.MAX_VALUE ? 2 : 4);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            ++this.count;
        } else {
            int index = super.put(obj);
            if (index < 0) {
                Serializer<?> serializer = Repository.get(obj.getClass());
                this.count += serializer.uid < 0L ? 1 : 8;
                serializer.calcSize(obj, this);
            } else {
                this.count += index <= 65535 ? 3 : 5;
                this.hasCycles = true;
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

