/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import one.nio.os.perf.CounterValue;

public class LocalValue
implements CounterValue {
    public final long value;
    public final long running;
    public final long enabled;

    public LocalValue(long value, long running, long enabled) {
        this.value = value;
        this.running = running;
        this.enabled = enabled;
    }

    @Override
    public double scalingFactor() {
        return this.running == this.enabled ? 1.0 : (double)this.enabled / (double)this.running;
    }

    @Override
    public double runningFraction() {
        return this.running == this.enabled ? 1.0 : (double)this.running / (double)this.enabled;
    }

    @Override
    public long normalized() {
        return this.enabled == this.running ? this.value : (long)((double)this.value * this.scalingFactor());
    }

    @Override
    public CounterValue sub(CounterValue prev) {
        return this.sub((LocalValue)prev);
    }

    public LocalValue sub(LocalValue v) {
        return new LocalValue(this.value - v.value, this.running - v.running, this.enabled - v.enabled);
    }
}

