/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import one.nio.mem.Allocator;
import one.nio.mem.DirectMemory;
import one.nio.mem.MallocMXBean;
import one.nio.mem.MappedFile;
import one.nio.mem.OutOfMemoryException;
import one.nio.mgt.Management;
import one.nio.util.JavaInternals;

public class Malloc
implements Allocator,
MallocMXBean {
    static final long SIGNATURE_V3 = 3688557425027998029L;
    static final long SIGNATURE_V2 = 3616499830990070093L;
    static final int SIGNATURE_OFFSET = 0;
    static final int CAPACITY_OFFSET = 8;
    static final int BASE_OFFSET = 16;
    static final int HEADER_SIZE = 8;
    static final int SIZE_OFFSET = 0;
    static final int LEFT_OFFSET = 4;
    static final int NEXT_OFFSET = 8;
    static final int PREV_OFFSET = 16;
    static final int BIN_COUNT = 120;
    static final int BIN_SIZE = 8;
    static final int BIN_SPACE = 1024;
    static final int MAX_CHUNK = 0x40000008;
    static final int MIN_CHUNK = 24;
    static final int OCCUPIED_MASK = Integer.MIN_VALUE;
    static final int FREE_MASK = 0x7FFFFFF8;
    final long base;
    final long capacity;
    private volatile long freeMemory;

    public Malloc(long capacity) {
        this.capacity = capacity & 0xFFFFFFFFFFFFFFF8L;
        this.base = DirectMemory.allocateAndClear(this.capacity, this);
        this.init();
    }

    public Malloc(long base, long capacity) {
        this.base = base;
        this.capacity = capacity & 0xFFFFFFFFFFFFFFF8L;
        this.init();
    }

    public Malloc(MappedFile mmap) {
        this.base = mmap.getAddr();
        this.capacity = mmap.getSize();
        this.init();
    }

    static int getBin(int size) {
        int index = 29 - Integer.numberOfLeadingZeros(size -= 9);
        return (index << 2) + (size >>> index & 3);
    }

    static int binSize(int bin) {
        return (4 + (++bin & 3) << (bin >>> 2)) + 8;
    }

    static int chooseBin(int size) {
        return Malloc.getBin(size + 1) - 1;
    }

    public final long base() {
        return this.base;
    }

    @Override
    public long getTotalMemory() {
        return this.capacity;
    }

    @Override
    public long getFreeMemory() {
        return this.freeMemory;
    }

    @Override
    public long getUsedMemory() {
        return this.getTotalMemory() - this.getFreeMemory();
    }

    @Override
    public long calloc(int size) {
        long address = this.malloc(size);
        DirectMemory.clearSmall(address, size);
        return address;
    }

    @Override
    public long malloc(int size) {
        int adjustedSize;
        int alignedSize = Math.max(size, 16) + 15 & 0xFFFFFFF8;
        int bin = Malloc.getBin(alignedSize);
        long address = this.mallocImpl(bin, adjustedSize = Malloc.binSize(bin));
        if (address != 0L) {
            return address;
        }
        throw new OutOfMemoryException("Failed to allocate " + size + " bytes");
    }

    final synchronized long mallocImpl(int bin, int size) {
        do {
            long address;
            if ((address = this.getChunk(bin, size)) == 0L) continue;
            return address + 8L;
        } while (++bin < 120);
        return 0L;
    }

    @Override
    public synchronized void free(long address) {
        int size = JavaInternals.unsafe.getInt((address -= 8L) + 0L) & 0x7FFFFFF8;
        long leftChunk = address - (long)JavaInternals.unsafe.getInt(address + 4L);
        long rightChunk = address + (long)size;
        int leftSize = JavaInternals.unsafe.getInt(leftChunk + 0L);
        int rightSize = JavaInternals.unsafe.getInt(rightChunk + 0L);
        this.freeMemory += (long)size;
        if (leftSize > 0) {
            size += leftSize;
            this.removeFreeChunk(leftChunk);
            address = leftChunk;
        }
        if (rightSize > 0) {
            size += rightSize;
            this.removeFreeChunk(rightChunk);
        }
        this.addFreeChunk(address, size);
    }

    public int allocatedSize(long address) {
        int size;
        if ((address -= 8L) >= this.base + 1024L && address < this.base + this.capacity - 16L && ((size = JavaInternals.unsafe.getInt(address + 0L)) & Integer.MIN_VALUE) != 0) {
            return (size & 0x7FFFFFF8) - 8;
        }
        return 0;
    }

    @Override
    public synchronized void verify() {
        long end = this.base + this.capacity - 16L;
        long actualFree = 0L;
        int prevSize = 0;
        for (long start = this.base + 1024L; start < end; start += (long)prevSize) {
            if (JavaInternals.unsafe.getInt(start + 4L) != prevSize) {
                throw new AssertionError((Object)("Corrupted chunk at address 0x" + Long.toHexString(start)));
            }
            int size = JavaInternals.unsafe.getInt(start + 0L);
            if (size > 0) {
                actualFree += (long)size;
            }
            prevSize = size & 0x7FFFFFF8;
        }
        if (this.freeMemory != actualFree) {
            throw new AssertionError((Object)("Corrupted freeMemory: stored=" + this.freeMemory + ", actual=" + actualFree));
        }
    }

    void init() {
        long signature = JavaInternals.unsafe.getLong(this.base + 0L);
        if (signature != 0L) {
            if (signature != 3688557425027998029L && signature != 3616499830990070093L) {
                throw new IllegalArgumentException("Incompatible Malloc image");
            }
            if (JavaInternals.unsafe.getLong(this.base + 8L) != this.capacity) {
                throw new IllegalArgumentException("Malloc capacity mismatch");
            }
            long oldBase = JavaInternals.unsafe.getLong(this.base + 16L);
            JavaInternals.unsafe.putLong(this.base + 16L, this.base);
            this.relocate(this.base - oldBase);
            if (signature == 3616499830990070093L) {
                this.upgradeBinFormat();
                JavaInternals.unsafe.putLong(this.base + 0L, 3688557425027998029L);
            }
        } else {
            int size;
            JavaInternals.unsafe.putLong(this.base + 0L, 3688557425027998029L);
            JavaInternals.unsafe.putLong(this.base + 8L, this.capacity);
            JavaInternals.unsafe.putLong(this.base + 16L, this.base);
            long start = this.base + 1024L;
            long end = this.base + this.capacity - 16L;
            if (end - start < 24L) {
                throw new IllegalArgumentException("Malloc area too small");
            }
            do {
                size = (int)Math.min(end - start, 0x40000008L);
                this.addFreeChunk(start, size);
                this.addBoundary(start + (long)size);
                this.freeMemory += (long)size;
            } while (end - (start += (long)(size + 8)) >= 24L);
        }
        Management.registerMXBean(this, "one.nio.mem:type=Malloc,base=" + Long.toHexString(this.base));
    }

    private void relocate(long delta) {
        for (int bin = Malloc.getBin(24); bin < 120; ++bin) {
            long chunk;
            long prev = this.base + (long)(bin * 8);
            while ((chunk = JavaInternals.unsafe.getLong(prev + 8L)) != 0L) {
                this.freeMemory += (long)JavaInternals.unsafe.getInt((chunk += delta) + 0L);
                JavaInternals.unsafe.putLong(prev + 8L, chunk);
                JavaInternals.unsafe.putLong(chunk + 16L, prev);
                prev = chunk;
            }
        }
    }

    private void upgradeBinFormat() {
        int bin;
        long[] firstChunk = new long[120];
        for (bin = Malloc.getBin(24); bin < 120; ++bin) {
            long binAddress = this.base + (long)(bin * 8) + 8L;
            firstChunk[bin] = JavaInternals.unsafe.getLong(binAddress);
            JavaInternals.unsafe.putLong(binAddress, 0L);
        }
        for (bin = Malloc.getBin(24); bin < 120; ++bin) {
            long chunk = firstChunk[bin];
            while (chunk != 0L) {
                int size = JavaInternals.unsafe.getInt(chunk + 0L);
                long next = JavaInternals.unsafe.getLong(chunk + 8L);
                this.addFreeChunk(chunk, size);
                chunk = next;
            }
        }
    }

    private void addBoundary(long address) {
        JavaInternals.unsafe.putInt(address + 0L, -2147483640);
        JavaInternals.unsafe.putInt(address + 8L + 4L, 8);
    }

    private long getChunk(int bin, int size) {
        long binAddress = this.base + (long)(bin * 8);
        long chunk = JavaInternals.unsafe.getLong(binAddress + 8L);
        if (chunk == 0L) {
            return 0L;
        }
        int chunkSize = JavaInternals.unsafe.getInt(chunk + 0L);
        int leftoverSize = chunkSize - size;
        assert (leftoverSize >= 0);
        if (leftoverSize < 24) {
            JavaInternals.unsafe.putInt(chunk + 0L, chunkSize | Integer.MIN_VALUE);
            this.freeMemory -= (long)chunkSize;
            this.removeFreeChunk(chunk);
            return chunk;
        }
        JavaInternals.unsafe.putInt(chunk + 0L, size | Integer.MIN_VALUE);
        this.freeMemory -= (long)size;
        this.removeFreeChunk(chunk);
        long leftoverChunk = chunk + (long)size;
        this.addFreeChunk(leftoverChunk, leftoverSize);
        JavaInternals.unsafe.putInt(leftoverChunk + 4L, size);
        return chunk;
    }

    private void addFreeChunk(long address, int size) {
        JavaInternals.unsafe.putInt(address + 0L, size);
        JavaInternals.unsafe.putInt(address + (long)size + 4L, size);
        long binAddress = this.base + (long)(Malloc.chooseBin(size) * 8);
        long head = JavaInternals.unsafe.getLong(binAddress + 8L);
        JavaInternals.unsafe.putLong(address + 8L, head);
        JavaInternals.unsafe.putLong(address + 16L, binAddress);
        JavaInternals.unsafe.putLong(binAddress + 8L, address);
        if (head != 0L) {
            JavaInternals.unsafe.putLong(head + 16L, address);
        }
    }

    private void removeFreeChunk(long address) {
        long next = JavaInternals.unsafe.getLong(address + 8L);
        long prev = JavaInternals.unsafe.getLong(address + 16L);
        JavaInternals.unsafe.putLong(prev + 8L, next);
        if (next != 0L) {
            JavaInternals.unsafe.putLong(next + 16L, prev);
        }
    }
}

