/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import one.nio.http.HttpException;
import one.nio.http.HttpServer;
import one.nio.http.Request;
import one.nio.http.Response;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.net.SocketClosedException;
import one.nio.util.Utf8;

public class HttpSession
extends Session {
    private static final int MAX_HEADERS = 256;
    private static final int MAX_FRAGMENT_LENGTH = 2048;
    private static final int MAX_PIPELINE_LENGTH = 256;
    private static final int MAX_REQUEST_BODY_LENGTH = 65536;
    private static final int HTTP_VERSION_LENGTH = 9;
    protected static final Request FIN = new Request(0, "", false);
    protected final HttpServer server;
    protected final LinkedList<Request> pipeline = new LinkedList();
    protected final byte[] fragment = new byte[2048];
    protected int fragmentLength;
    protected int requestBodyOffset;
    protected Request parsing;
    protected volatile Request handling;

    public HttpSession(Socket socket, HttpServer server) {
        super(socket);
        this.server = server;
    }

    @Override
    public int checkStatus(long currentTime, long keepAlive) {
        long lastAccessTime = this.lastAccessTime;
        if (lastAccessTime < currentTime - keepAlive) {
            if (this.queueHead == null && this.handling == null) {
                return 1;
            }
            if (lastAccessTime < currentTime - keepAlive * 8L) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    protected void processRead(byte[] buffer) throws IOException {
        int length = this.fragmentLength;
        if (length > 0) {
            System.arraycopy(this.fragment, 0, buffer, 0, length);
        }
        try {
            length += super.read(buffer, length, buffer.length - length);
        }
        catch (SocketClosedException e) {
            this.handleSocketClosed();
            return;
        }
        try {
            int processed = this.processHttpBuffer(buffer, length);
            if ((length -= processed) > 0) {
                if (length > 2048) {
                    throw new HttpException("Line too long");
                }
                System.arraycopy(buffer, processed, this.fragment, 0, length);
            }
            this.fragmentLength = length;
        }
        catch (HttpException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Bad request", (Throwable)e);
            }
            this.sendError("400 Bad Request", e.getMessage());
        }
        catch (BufferOverflowException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request entity too large", (Throwable)e);
            }
            this.sendError("413 Request Entity Too Large", "");
        }
    }

    protected void handleSocketClosed() {
        if (this.closing) {
            return;
        }
        this.listen(this.queueHead == null ? 0 : 4);
        if (this.handling == null) {
            this.scheduleClose();
        } else {
            this.pipeline.addLast(FIN);
        }
    }

    protected int getMaxRequestBodyLength() {
        return 65536;
    }

    protected int startParsingRequestBody(String contentLengthHeader, byte[] buffer, int offset, int remaining) throws IOException, HttpException {
        int contentLength;
        try {
            contentLength = Integer.parseInt(contentLengthHeader);
        }
        catch (NumberFormatException e) {
            throw new HttpException("Invalid Content-Length header");
        }
        if (contentLength < 0) {
            throw new HttpException("Invalid Content-Length header");
        }
        if (contentLength > this.getMaxRequestBodyLength()) {
            throw new BufferOverflowException();
        }
        byte[] body = new byte[contentLength];
        this.requestBodyOffset = Math.min(remaining, contentLength);
        System.arraycopy(buffer, offset, body, 0, this.requestBodyOffset);
        this.parsing.setBody(body);
        return this.requestBodyOffset;
    }

    protected void handleParsedRequest() throws IOException {
        if (this.handling == null) {
            this.handling = this.parsing;
            this.server.handleRequest(this.handling, this);
        } else if (this.pipeline.size() < 256) {
            this.pipeline.addLast(this.parsing);
        } else {
            throw new IOException("Pipeline length exceeded");
        }
        this.parsing = null;
        this.requestBodyOffset = 0;
    }

    protected int processHttpBuffer(byte[] buffer, int length) throws IOException, HttpException {
        int lineStart = 0;
        if (this.parsing != null && this.parsing.getBody() != null) {
            byte[] body = this.parsing.getBody();
            int remaining = Math.min(length, body.length - this.requestBodyOffset);
            System.arraycopy(buffer, 0, body, this.requestBodyOffset, remaining);
            this.requestBodyOffset += remaining;
            if (this.requestBodyOffset < body.length) {
                return length;
            }
            if (this.closing) {
                return remaining;
            }
            this.handleParsedRequest();
            lineStart = remaining;
        }
        for (int i = lineStart; i < length; ++i) {
            if (buffer[i] != 10) continue;
            int lineLength = i - lineStart;
            if (i > 0 && buffer[i - 1] == 13) {
                --lineLength;
            }
            ++i;
            if (this.parsing == null) {
                this.parsing = this.parseRequest(buffer, lineStart, lineLength);
            } else if (lineLength > 0) {
                if (this.parsing.getHeaderCount() < 256) {
                    this.parsing.addHeader(Utf8.read(buffer, lineStart, lineLength));
                }
            } else {
                String contentLengthHeader = this.parsing.getHeader("Content-Length:");
                if (contentLengthHeader != null) {
                    i += this.startParsingRequestBody(contentLengthHeader, buffer, i, length - i);
                    if (this.requestBodyOffset < this.parsing.getBody().length) {
                        return i;
                    }
                }
                if (this.closing) {
                    return i;
                }
                this.handleParsedRequest();
            }
            lineStart = i;
        }
        return lineStart;
    }

    protected Request parseRequest(byte[] buffer, int start, int length) throws HttpException {
        for (int i = 1; i < Request.VERBS.length; ++i) {
            byte[] verb = Request.VERBS[i];
            int auxLength = verb.length + 9;
            if (length <= auxLength || !Utf8.startsWith(verb, buffer, start)) continue;
            String uri = Utf8.read(buffer, start + verb.length, length - auxLength);
            return new Request(i, uri, buffer[start + length - 1] == 49);
        }
        throw new HttpException("Invalid request");
    }

    public synchronized void sendResponse(Response response) throws IOException {
        Request handling = this.handling;
        if (handling == null) {
            throw new IOException("Out of order response");
        }
        this.server.incRequestsProcessed();
        String connection = handling.getHeader("Connection:");
        boolean keepAlive = handling.isHttp11() ? !"close".equalsIgnoreCase(connection) : "Keep-Alive".equalsIgnoreCase(connection);
        response.addHeader(keepAlive ? "Connection: Keep-Alive" : "Connection: close");
        this.writeResponse(response, handling.getMethod() != 3);
        if (!keepAlive) {
            this.scheduleClose();
        }
        this.handling = handling = this.pipeline.pollFirst();
        if (handling != null) {
            if (handling == FIN) {
                this.scheduleClose();
            } else {
                this.server.handleRequest(handling, this);
            }
        }
    }

    public synchronized void sendError(String code, String message) throws IOException {
        this.server.incRequestsRejected();
        Response response = new Response(code, message == null ? Response.EMPTY : Utf8.toBytes(message));
        response.addHeader("Connection: close");
        this.writeResponse(response, true);
        this.scheduleClose();
    }

    protected void writeResponse(Response response, boolean includeBody) throws IOException {
        byte[] bytes = response.toBytes(includeBody);
        super.write(bytes, 0, bytes.length);
    }
}

