/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import one.nio.http.HttpException;
import one.nio.http.Request;
import one.nio.http.Response;
import one.nio.net.ConnectionString;
import one.nio.net.HttpProxy;
import one.nio.net.Socket;
import one.nio.net.SslContext;
import one.nio.pool.PoolException;
import one.nio.pool.SocketPool;
import one.nio.util.Utf8;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClient
extends SocketPool {
    protected static final Log log = LogFactory.getLog(HttpClient.class);
    protected String[] permanentHeaders;
    protected int bufferSize;

    public HttpClient(ConnectionString conn) {
        this(conn, "Host: " + conn.getHost(), conn.getBooleanParam("keepalive", true) ? "Connection: Keep-Alive" : "Connection: close");
    }

    public HttpClient(ConnectionString conn, String ... permanentHeaders) {
        super(conn);
        this.permanentHeaders = permanentHeaders;
    }

    @Override
    protected void setProperties(ConnectionString conn) {
        String proxyAddr;
        boolean https = "https".equals(conn.getProtocol());
        if (https) {
            this.sslContext = SslContext.getDefault();
        }
        if (this.port == 0) {
            int n = this.port = https ? 443 : 80;
        }
        if ((proxyAddr = conn.getStringParam("proxy")) != null) {
            int p = proxyAddr.lastIndexOf(58);
            if (p >= 0) {
                String proxyHost = proxyAddr.substring(0, p);
                int proxyPort = Integer.parseInt(proxyAddr.substring(p + 1));
                this.setProxy(new HttpProxy(proxyHost, proxyPort));
            } else {
                this.setProxy(new HttpProxy(proxyAddr, 3128));
            }
        }
        this.bufferSize = conn.getIntParam("bufferSize", 8000);
    }

    public Response invoke(Request request) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(request, this.readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke(Request request, int timeout) throws InterruptedException, PoolException, IOException, HttpException {
        int method = request.getMethod();
        byte[] rawRequest = request.toBytes();
        Socket socket = (Socket)this.borrowObject();
        boolean keepAlive = false;
        try {
            ResponseReader responseReader;
            try {
                socket.setTimeout(timeout == 0 ? this.readTimeout : timeout);
                socket.writeFully(rawRequest, 0, rawRequest.length);
                responseReader = new ResponseReader(socket, this.bufferSize);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                this.destroyObject(socket);
                socket = this.createObject();
                socket.writeFully(rawRequest, 0, rawRequest.length);
                responseReader = new ResponseReader(socket, this.bufferSize);
            }
            Response response = responseReader.readResponse(method);
            keepAlive = !"close".equalsIgnoreCase(response.getHeader("Connection:"));
            Response response2 = response;
            return response2;
        }
        finally {
            if (keepAlive) {
                this.returnObject(socket);
            } else {
                this.invalidateObject(socket);
            }
        }
    }

    public Response get(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(1, uri, headers));
    }

    public Response delete(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(6, uri, headers));
    }

    public Response post(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(2, uri, headers));
    }

    public Response post(String uri, byte[] body, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        Request request = this.createRequest(2, uri, headers);
        if (body != null) {
            request.addHeader("Content-Length: " + body.length);
            request.setBody(body);
        }
        return this.invoke(request);
    }

    public Response put(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(5, uri, headers));
    }

    public Response put(String uri, byte[] body, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        Request request = this.createRequest(5, uri, headers);
        if (body != null) {
            request.addHeader("Content-Length: " + body.length);
            request.setBody(body);
        }
        return this.invoke(request);
    }

    public Response patch(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(9, uri, headers));
    }

    public Response patch(String uri, byte[] body, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        Request request = this.createRequest(9, uri, headers);
        if (body != null) {
            request.addHeader("Content-Length: " + body.length);
            request.setBody(body);
        }
        return this.invoke(request);
    }

    public Response head(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(3, uri, headers));
    }

    public Response options(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(4, uri, headers));
    }

    public Response trace(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(7, uri, headers));
    }

    public Response connect(String uri, String ... headers) throws InterruptedException, PoolException, IOException, HttpException {
        return this.invoke(this.createRequest(8, uri, headers));
    }

    public Request createRequest(int method, String uri, String ... headers) {
        Request request = new Request(method, uri, true);
        for (String header : this.permanentHeaders) {
            request.addHeader(header);
        }
        for (String header : headers) {
            request.addHeader(header);
        }
        return request;
    }

    static class ResponseReader {
        Socket socket;
        byte[] buf;
        int length;
        int pos;

        ResponseReader(Socket socket, int bufferSize) throws IOException {
            this.socket = socket;
            this.buf = new byte[bufferSize];
            this.length = socket.read(this.buf, 0, bufferSize, 0);
        }

        Response readResponse(int method) throws IOException, HttpException {
            String header;
            String responseHeader = this.readLine();
            if (responseHeader.length() <= 9) {
                throw new HttpException("Invalid response header: " + responseHeader);
            }
            Response response = new Response(responseHeader.substring(9));
            while (!(header = this.readLine()).isEmpty()) {
                response.addHeader(header);
            }
            if (method != 3 && ResponseReader.mayHaveBody(response.getStatus())) {
                if ("chunked".equalsIgnoreCase(response.getHeader("Transfer-Encoding:"))) {
                    response.setBody(this.readChunkedBody());
                } else {
                    String contentLength = response.getHeader("Content-Length:");
                    if (contentLength == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Content-Length unspecified: " + response.toString()));
                        }
                        throw new HttpException("Content-Length unspecified");
                    }
                    byte[] body = new byte[Integer.parseInt(contentLength)];
                    int contentBytes = this.length - this.pos;
                    System.arraycopy(this.buf, this.pos, body, 0, contentBytes);
                    if (contentBytes < body.length) {
                        this.socket.readFully(body, contentBytes, body.length - contentBytes);
                    }
                    response.setBody(body);
                }
            }
            return response;
        }

        String readLine() throws IOException, HttpException {
            int pos;
            byte[] buf = this.buf;
            int lineStart = pos = this.pos;
            do {
                if (pos != this.length) continue;
                if (pos >= buf.length) {
                    throw new HttpException("Line too long");
                }
                this.length += this.socket.read(buf, pos, buf.length - pos, 0);
            } while (buf[pos++] != 10);
            this.pos = pos;
            return Utf8.read(buf, lineStart, pos - lineStart - 2);
        }

        byte[] readChunkedBody() throws IOException, HttpException {
            ArrayList<byte[]> chunks = new ArrayList<byte[]>(4);
            int totalBytes = 0;
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(this.readLine(), 16)) == 0) break;
                byte[] chunk = new byte[chunkSize];
                chunks.add(chunk);
                totalBytes += chunkSize;
                int contentBytes = this.length - this.pos;
                if (contentBytes < chunkSize) {
                    System.arraycopy(this.buf, this.pos, chunk, 0, contentBytes);
                    this.socket.readFully(chunk, contentBytes, chunkSize - contentBytes);
                    this.pos = 0;
                    this.length = 0;
                } else {
                    System.arraycopy(this.buf, this.pos, chunk, 0, chunkSize);
                    this.pos += chunkSize;
                    if (this.pos + 128 >= this.buf.length) {
                        System.arraycopy(this.buf, this.pos, this.buf, 0, this.length -= this.pos);
                        this.pos = 0;
                    }
                }
                this.readLine();
            }
            this.readLine();
            byte[] result = new byte[totalBytes];
            int position = 0;
            for (byte[] chunk : chunks) {
                System.arraycopy(chunk, 0, result, position, chunk.length);
                position += chunk.length;
            }
            return result;
        }

        private static boolean mayHaveBody(int status) {
            return status >= 200 && status != 204 && status != 304;
        }
    }
}

