/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.gen.BytecodeGenerator;
import one.nio.serial.Renamed;
import one.nio.serial.Repository;

public class TypeDescriptor {
    private static final Class[] PRIMITIVE_CLASSES = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    static final AtomicInteger unknownTypes = new AtomicInteger();
    private Class cls;
    private String descriptor;

    TypeDescriptor(Class cls) {
        this.cls = cls;
        this.descriptor = TypeDescriptor.classDescriptor(cls);
    }

    TypeDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String toString() {
        return this.descriptor;
    }

    public static TypeDescriptor read(ObjectInput in) throws IOException {
        byte primitiveIndex = in.readByte();
        if (primitiveIndex >= 0) {
            return new TypeDescriptor(PRIMITIVE_CLASSES[primitiveIndex]);
        }
        return new TypeDescriptor(in.readUTF());
    }

    public void write(ObjectOutput out) throws IOException {
        if (this.cls != null && this.cls.isPrimitive()) {
            TypeDescriptor.writeClass(out, this.cls);
        } else {
            out.writeByte(-1);
            out.writeUTF(this.descriptor);
        }
    }

    public Class resolve() {
        if (this.cls == null) {
            try {
                this.cls = TypeDescriptor.resolve(this.descriptor);
            }
            catch (ClassNotFoundException e) {
                this.cls = this.resolveUnknown();
            }
        }
        return this.cls;
    }

    private Class resolveUnknown() {
        Repository.log.warn((Object)("Local type not found: " + this.descriptor));
        unknownTypes.incrementAndGet();
        if (this.descriptor.startsWith("[")) {
            this.descriptor = TypeDescriptor.classDescriptor(Object[].class);
            return Object[].class;
        }
        return Object.class;
    }

    public static Class<?> resolve(String descriptor) throws ClassNotFoundException {
        Class<?> renamedClass;
        int p = descriptor.indexOf(124);
        if (p >= 0) {
            try {
                return Class.forName(descriptor.substring(0, p), true, BytecodeGenerator.INSTANCE);
            }
            catch (ClassNotFoundException e) {
                descriptor = descriptor.substring(p + 1);
            }
        }
        return (renamedClass = Repository.renamedClasses.get(descriptor)) != null ? renamedClass : Class.forName(descriptor, true, BytecodeGenerator.INSTANCE);
    }

    public static String classDescriptor(Class<?> cls) {
        Renamed renamed = cls.getAnnotation(Renamed.class);
        return renamed == null ? cls.getName() : cls.getName() + '|' + renamed.from();
    }

    public static Class<?> readClass(ObjectInput in) throws IOException, ClassNotFoundException {
        byte index = in.readByte();
        if (index >= 0) {
            return PRIMITIVE_CLASSES[index];
        }
        return TypeDescriptor.resolve(in.readUTF());
    }

    public static void writeClass(ObjectOutput out, Class<?> cls) throws IOException {
        if (cls.isPrimitive()) {
            for (int i = 0; i < PRIMITIVE_CLASSES.length; ++i) {
                if (cls != PRIMITIVE_CLASSES[i]) continue;
                out.writeByte(i);
                return;
            }
        }
        out.writeByte(-1);
        out.writeUTF(TypeDescriptor.classDescriptor(cls));
    }
}

