/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mgt;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import one.nio.mgt.DiagnosticCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadDumper {
    private static final Log log = LogFactory.getLog(ThreadDumper.class);
    private static final AtomicLong dumpTime = new AtomicLong();

    public static void dump(OutputStream out) {
        String threadDump;
        try {
            threadDump = DiagnosticCommand.execute("threadPrint", new String[0]);
        }
        catch (JMException e) {
            log.warn((Object)("Failed to get threads dump: " + e));
            return;
        }
        PrintStream printStream = out == null ? System.out : new PrintStream(out);
        printStream.println(threadDump);
    }

    public static void dump(OutputStream out, long minDumpInterval) {
        long lastDumpTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastDumpTime = dumpTime.get()) >= minDumpInterval && dumpTime.compareAndSet(lastDumpTime, currentTime)) {
            ThreadDumper.dump(out);
        }
    }
}

