/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import one.nio.mem.Allocator;
import one.nio.mem.DirectMemory;
import one.nio.mem.OutOfMemoryException;
import one.nio.util.JavaInternals;

public class FixedSizeAllocator
implements Allocator {
    protected static final long headOffset = JavaInternals.fieldOffset(FixedSizeAllocator.class, "head");
    private static final long ADDR_MASK = 0xFFFFFFFFFFFFL;
    private static final long COUNTER_MASK = -281474976710656L;
    private static final long COUNTER_INC = 0x1000000000000L;
    private volatile long p1;
    private volatile long p2;
    private volatile long p3;
    private volatile long p4;
    private volatile long p5;
    private volatile long p6;
    private volatile long p7 = 0L;
    protected volatile long head;
    private volatile long q1;
    private volatile long q2;
    private volatile long q3;
    private volatile long q4;
    private volatile long q5;
    private volatile long q6;
    private volatile long q7 = 0L;
    protected long entrySize;
    protected long chunkSize;
    protected long totalMemory;

    public FixedSizeAllocator(long entrySize, long chunkSize) {
        this.entrySize = entrySize;
        this.chunkSize = chunkSize;
        this.requestMoreMemory();
    }

    public FixedSizeAllocator(long startAddress, long totalMemory, long entrySize) {
        this.entrySize = entrySize;
        this.chunkSize = 0L;
        this.totalMemory = totalMemory;
        this.head = startAddress;
        long lastEntry = startAddress + (totalMemory / entrySize - 1L) * entrySize;
        long entry = startAddress;
        while (entry < lastEntry) {
            JavaInternals.unsafe.putAddress(entry, entry += entrySize);
        }
    }

    public FixedSizeAllocator(long startAddress, long totalMemory, long entrySize, long head) {
        this.entrySize = entrySize;
        this.chunkSize = 0L;
        this.totalMemory = totalMemory;
        this.head = head;
    }

    public static void relocate(long currentPtr, long delta) {
        long entry;
        while ((entry = JavaInternals.unsafe.getAddress(currentPtr)) != 0L) {
            entry = (entry & 0xFFFFFFFFFFFFL) + delta;
            JavaInternals.unsafe.putAddress(currentPtr, entry);
            currentPtr = entry;
        }
    }

    public int countFreePages() {
        int count = 0;
        long entry = this.head & 0xFFFFFFFFFFFFL;
        while (entry != 0L) {
            ++count;
            entry = JavaInternals.unsafe.getAddress(entry);
        }
        return count;
    }

    public long entrySize() {
        return this.entrySize;
    }

    public long chunkSize() {
        return this.chunkSize;
    }

    public long totalMemory() {
        return this.totalMemory;
    }

    public long malloc() {
        long entry;
        while (true) {
            long head;
            if ((entry = (head = this.head) & 0xFFFFFFFFFFFFL) == 0L) {
                this.requestMoreMemory();
                continue;
            }
            long nextEntry = JavaInternals.unsafe.getAddress(entry);
            if (JavaInternals.unsafe.compareAndSwapLong(this, headOffset, head, nextEntry + (head & 0xFFFF000000000000L) + 0x1000000000000L)) break;
        }
        return entry;
    }

    @Override
    public long malloc(int size) {
        assert ((long)size == this.entrySize);
        return this.malloc();
    }

    @Override
    public long calloc(int size) {
        long address = this.malloc(size);
        DirectMemory.clearSmall(address, size);
        return address;
    }

    @Override
    public void free(long entry) {
        long head;
        do {
            head = this.head;
            JavaInternals.unsafe.putAddress(entry, head & 0xFFFFFFFFFFFFL);
        } while (!JavaInternals.unsafe.compareAndSwapLong(this, headOffset, head, entry + (head & 0xFFFF000000000000L) + 0x1000000000000L));
    }

    @Override
    public void verify() {
    }

    private synchronized void requestMoreMemory() {
        long head;
        if ((this.head & 0xFFFFFFFFFFFFL) != 0L) {
            return;
        }
        long newChunk = this.getMemoryFromSystem(this.chunkSize);
        this.totalMemory += this.chunkSize;
        long lastEntry = newChunk + (this.chunkSize / this.entrySize - 1L) * this.entrySize;
        long entry = newChunk;
        while (entry < lastEntry) {
            JavaInternals.unsafe.putAddress(entry, entry += this.entrySize);
        }
        do {
            head = this.head;
            JavaInternals.unsafe.putAddress(lastEntry, head & 0xFFFFFFFFFFFFL);
        } while (!JavaInternals.unsafe.compareAndSwapLong(this, headOffset, head, newChunk));
    }

    protected long getMemoryFromSystem(long size) {
        if (size == 0L) {
            throw new OutOfMemoryException("FixedSizeAllocator has reached its limit");
        }
        return JavaInternals.unsafe.allocateMemory(size);
    }
}

