/*
 * Decompiled with CFR 0.152.
 */
package one.nio.gen;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.gen.BytecodeGeneratorMXBean;
import one.nio.mgt.Management;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class BytecodeGenerator
extends ClassLoader
implements BytecodeGeneratorMXBean,
Opcodes {
    private static final Log log = LogFactory.getLog(BytecodeGenerator.class);
    public static final BytecodeGenerator INSTANCE = new BytecodeGenerator();
    protected final AtomicInteger totalClasses = new AtomicInteger();
    protected final AtomicInteger totalBytes = new AtomicInteger();
    protected String dumpPath = System.getProperty("one.nio.gen.dump");

    public BytecodeGenerator() {
        super(BytecodeGenerator.class.getClassLoader());
    }

    public Class<?> defineClass(byte[] classData) {
        Class<?> result = super.defineClass(null, classData, 0, classData.length, null);
        this.totalClasses.incrementAndGet();
        this.totalBytes.addAndGet(classData.length);
        if (this.dumpPath != null && !"".equals(this.dumpPath)) {
            this.dumpClass(classData, result.getSimpleName());
        }
        return result;
    }

    public synchronized Class<?> defineClassIfNotExists(String className, byte[] classData) {
        Class<?> result = this.findLoadedClass(className);
        if (result == null) {
            result = this.defineClass(classData);
        }
        return result;
    }

    public <T> T instantiate(byte[] classData, Class<T> iface) {
        try {
            return (T)this.defineClass(classData).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate class", e);
        }
    }

    public void dumpClass(byte[] classData, String className) {
        try {
            Files.write(Paths.get(this.dumpPath, className + ".class"), classData, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            log.error((Object)("Could not dump " + className), (Throwable)e);
        }
    }

    public static void emitGetField(MethodVisitor mv, Field f) {
        int opcode = (f.getModifiers() & 8) != 0 ? 178 : 180;
        String holder = Type.getInternalName(f.getDeclaringClass());
        String name = f.getName();
        String sig = Type.getDescriptor(f.getType());
        mv.visitFieldInsn(opcode, holder, name, sig);
    }

    public static void emitPutField(MethodVisitor mv, Field f) {
        int opcode = (f.getModifiers() & 8) != 0 ? 179 : 181;
        String holder = Type.getInternalName(f.getDeclaringClass());
        String name = f.getName();
        String sig = Type.getDescriptor(f.getType());
        mv.visitFieldInsn(opcode, holder, name, sig);
    }

    public static void emitInvoke(MethodVisitor mv, Method m) {
        int opcode = (m.getModifiers() & 8) != 0 ? 184 : ((m.getModifiers() & 2) != 0 ? 183 : (m.getDeclaringClass().isInterface() ? 185 : 182));
        String holder = Type.getInternalName(m.getDeclaringClass());
        String name = m.getName();
        String sig = Type.getMethodDescriptor((Method)m);
        mv.visitMethodInsn(opcode, holder, name, sig);
    }

    public static void emitInvoke(MethodVisitor mv, Constructor c) {
        String holder = Type.getInternalName(c.getDeclaringClass());
        String sig = Type.getConstructorDescriptor((Constructor)c);
        mv.visitMethodInsn(183, holder, "<init>", sig);
    }

    public static void emitThrow(MethodVisitor mv, String exceptionClass, String message) {
        mv.visitTypeInsn(187, exceptionClass);
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)message);
        mv.visitMethodInsn(183, exceptionClass, "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
    }

    public static void emitInt(MethodVisitor mv, int c) {
        if (c >= -1 && c <= 5) {
            mv.visitInsn(3 + c);
        } else if (c >= -128 && c <= 127) {
            mv.visitIntInsn(16, c);
        } else if (c >= Short.MIN_VALUE && c <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, c);
        } else {
            mv.visitLdcInsn((Object)c);
        }
    }

    public static void emitLong(MethodVisitor mv, long c) {
        if (c >= 0L && c <= 1L) {
            mv.visitInsn(9 + (int)c);
        } else {
            mv.visitLdcInsn((Object)c);
        }
    }

    public static void emitFloat(MethodVisitor mv, float c) {
        if (c == 0.0f) {
            mv.visitInsn(11);
        } else if (c == 1.0f) {
            mv.visitInsn(12);
        } else if (c == 2.0f) {
            mv.visitInsn(13);
        } else {
            mv.visitLdcInsn((Object)Float.valueOf(c));
        }
    }

    public static void emitDouble(MethodVisitor mv, double c) {
        if (c == 0.0) {
            mv.visitInsn(14);
        } else if (c == 1.0) {
            mv.visitInsn(15);
        } else {
            mv.visitLdcInsn((Object)c);
        }
    }

    public static void emitBoxing(MethodVisitor mv, Class type) {
        if (type == Boolean.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (type == Byte.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (type == Character.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (type == Short.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (type == Integer.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (type == Float.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (type == Long.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (type == Double.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (type == Void.TYPE) {
            mv.visitInsn(1);
        } else {
            throw new IllegalArgumentException("Not a primitive type: " + type);
        }
    }

    public static void emitUnboxing(MethodVisitor mv, Class type) {
        if (type == Boolean.class) {
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (type == Byte.class) {
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (type == Character.class) {
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        } else if (type == Short.class) {
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (type == Integer.class) {
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (type == Float.class) {
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (type == Long.class) {
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (type == Double.class) {
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        } else {
            throw new IllegalArgumentException("Not a wrapper type: " + type);
        }
    }

    @Override
    public String getDumpPath() {
        return this.dumpPath;
    }

    @Override
    public void setDumpPath(String dumpPath) {
        this.dumpPath = dumpPath;
    }

    @Override
    public int getTotalClasses() {
        return this.totalClasses.get();
    }

    @Override
    public int getTotalBytes() {
        return this.totalBytes.get();
    }

    static {
        Management.registerMXBean(INSTANCE, "one.nio.gen:type=BytecodeGenerator");
    }
}

