/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.gen.BytecodeGenerator;
import one.nio.util.DateFormat;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class DateFormatGenerator
extends BytecodeGenerator {
    private static final AtomicInteger index = new AtomicInteger();
    private static final String[] DAY_NAMES = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static final String[] MONTH_NAMES = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final int YEAR = 1;
    private static final int MONTH = 2;
    private static final int DAY_OF_MONTH = 3;
    private static final int DAY_OF_WEEK = 4;
    private static final int HOUR = 5;
    private static final int MINUTE = 6;
    private static final int SECOND = 7;
    private static final int MILLISECOND = 8;
    private static final int ZONE_OFFSET = 9;
    private static final int TIME_ZONE = 10;

    static DateFormat generateForPattern(String pattern, String timeZone) {
        ArrayList<Object> fields = new ArrayList<Object>();
        int fieldSet = 0;
        int patternWidth = 0;
        int length = pattern.length();
        boolean literal = false;
        for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (c == '\'') {
                literal = !literal;
                continue;
            }
            if ((c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && !literal) {
                int start = i;
                while (i + 1 < length && pattern.charAt(i + 1) == c) {
                    ++i;
                }
                CalendarField field = DateFormatGenerator.getCalendarField(c, i - start + 1);
                if (field == null) {
                    throw new IllegalArgumentException("Invalid format character '" + c + "' at position " + i);
                }
                fields.add(field);
                patternWidth += field.width;
                fieldSet |= 1 << field.type;
                continue;
            }
            if (c == '\"' && !literal) {
                fields.add(Character.valueOf('\''));
                ++patternWidth;
                continue;
            }
            fields.add(Character.valueOf(c));
            ++patternWidth;
        }
        return new DateFormatGenerator().generate(fields, fieldSet, patternWidth, timeZone);
    }

    private DateFormat generate(List<Object> fields, int fieldSet, int patternWidth, String timeZone) {
        boolean isUTC;
        String className = "one/nio/util/GeneratedDateFormat" + index.getAndIncrement();
        ClassWriter cv = new ClassWriter(3);
        cv.visit(50, 17, className, null, "one/nio/util/DateFormat", new String[0]);
        cv.visitField(26, "tz", "Ljava/util/TimeZone;", null, null).visitEnd();
        MethodVisitor mv = cv.visitMethod(1, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)timeZone);
        mv.visitMethodInsn(184, "java/util/TimeZone", "getTimeZone", "(Ljava/lang/String;)Ljava/util/TimeZone;");
        mv.visitFieldInsn(179, className, "tz", "Ljava/util/TimeZone;");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "one/nio/util/DateFormat", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cv.visitMethod(17, "format", "(J)Ljava/lang/String;", null, null);
        mv.visitCode();
        boolean bl = isUTC = "GMT".equals(timeZone) || "UTC".equals(timeZone);
        if (!isUTC) {
            mv.visitVarInsn(22, 1);
            mv.visitFieldInsn(178, className, "tz", "Ljava/util/TimeZone;");
            mv.visitVarInsn(22, 1);
            mv.visitMethodInsn(182, "java/util/TimeZone", "getOffset", "(J)I");
            if ((fieldSet & 0x200) != 0) {
                mv.visitInsn(89);
                mv.visitVarInsn(54, 4);
            }
            mv.visitInsn(133);
            mv.visitInsn(97);
            mv.visitVarInsn(55, 1);
        }
        if ((fieldSet & 0xE) != 0) {
            mv.visitVarInsn(22, 1);
            mv.visitMethodInsn(184, "one/nio/util/Dates", "dateOfMillis", "(J)I");
            mv.visitVarInsn(54, 5);
        }
        if ((fieldSet & 0xE0) != 0) {
            mv.visitVarInsn(22, 1);
            mv.visitLdcInsn((Object)-11676096000000L);
            mv.visitInsn(101);
            mv.visitLdcInsn((Object)86400000L);
            mv.visitInsn(113);
            mv.visitInsn(136);
            DateFormatGenerator.emitInt(mv, 1000);
            mv.visitInsn(108);
            mv.visitVarInsn(54, 6);
        }
        DateFormatGenerator.emitInt(mv, patternWidth);
        mv.visitIntInsn(188, 5);
        mv.visitVarInsn(58, 3);
        int off = 0;
        for (Object f : fields) {
            mv.visitVarInsn(25, 3);
            DateFormatGenerator.emitInt(mv, off);
            if (f instanceof Character) {
                DateFormatGenerator.emitInt(mv, ((Character)f).charValue());
                mv.visitInsn(85);
                ++off;
                continue;
            }
            CalendarField cf = (CalendarField)f;
            switch (cf.type) {
                case 1: {
                    mv.visitVarInsn(21, 5);
                    mv.visitMethodInsn(184, "one/nio/util/Dates", "year", "(I)I");
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", "putYear" + cf.width, "([CII)V");
                    break;
                }
                case 2: {
                    mv.visitVarInsn(21, 5);
                    mv.visitMethodInsn(184, "one/nio/util/Dates", "month", "(I)I");
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", cf.width == 3 ? "putMonth" : "putInt", "([CII)V");
                    break;
                }
                case 3: {
                    mv.visitVarInsn(21, 5);
                    mv.visitMethodInsn(184, "one/nio/util/Dates", "day", "(I)I");
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", "putInt", "([CII)V");
                    break;
                }
                case 4: {
                    mv.visitVarInsn(22, 1);
                    mv.visitMethodInsn(184, "one/nio/util/Dates", "dayNum", "(J)I");
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", "putDayOfWeek", "([CII)V");
                    break;
                }
                case 5: {
                    mv.visitVarInsn(21, 6);
                    DateFormatGenerator.emitInt(mv, 3600);
                    mv.visitInsn(108);
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", "putInt", "([CII)V");
                    break;
                }
                case 6: {
                    mv.visitVarInsn(21, 6);
                    DateFormatGenerator.emitInt(mv, 3600);
                    mv.visitInsn(112);
                    DateFormatGenerator.emitInt(mv, 60);
                    mv.visitInsn(108);
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", "putInt", "([CII)V");
                    break;
                }
                case 7: {
                    mv.visitVarInsn(21, 6);
                    DateFormatGenerator.emitInt(mv, 60);
                    mv.visitInsn(112);
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", "putInt", "([CII)V");
                    break;
                }
                case 8: {
                    mv.visitVarInsn(22, 1);
                    mv.visitLdcInsn((Object)-11676096000000L);
                    mv.visitInsn(101);
                    mv.visitLdcInsn((Object)1000L);
                    mv.visitInsn(113);
                    mv.visitInsn(136);
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", "putMillis" + cf.width, "([CII)V");
                    break;
                }
                case 9: {
                    if (isUTC) {
                        DateFormatGenerator.emitInt(mv, 0);
                    } else {
                        mv.visitVarInsn(21, 4);
                        DateFormatGenerator.emitInt(mv, 60000);
                        mv.visitInsn(108);
                    }
                    mv.visitMethodInsn(184, "one/nio/util/DateFormatGenerator", "putZoneOffset", "([CII)V");
                    break;
                }
                case 10: {
                    String id = TimeZone.getTimeZone(timeZone).getDisplayName(false, 0, Locale.US);
                    for (int i = 0; i < id.length(); ++i) {
                        if (i != 0) {
                            mv.visitVarInsn(25, 3);
                            DateFormatGenerator.emitInt(mv, off + i);
                        }
                        DateFormatGenerator.emitInt(mv, id.charAt(i));
                        mv.visitInsn(85);
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should not reach here");
                }
            }
            off += cf.width;
        }
        mv.visitTypeInsn(187, "java/lang/String");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, "java/lang/String", "<init>", "([C)V");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cv.visitEnd();
        return this.instantiate(cv.toByteArray(), DateFormat.class);
    }

    private static CalendarField getCalendarField(char c, int width) {
        switch (c) {
            case 'y': {
                return width == 2 || width == 4 ? new CalendarField(1, width) : null;
            }
            case 'M': {
                return width == 2 || width == 3 ? new CalendarField(2, width) : null;
            }
            case 'd': {
                return width == 2 ? new CalendarField(3, width) : null;
            }
            case 'H': {
                return width == 2 ? new CalendarField(5, width) : null;
            }
            case 'm': {
                return width == 2 ? new CalendarField(6, width) : null;
            }
            case 's': {
                return width == 2 ? new CalendarField(7, width) : null;
            }
            case 'S': {
                return width <= 3 ? new CalendarField(8, width) : null;
            }
            case 'E': {
                return width <= 3 ? new CalendarField(4, 3) : null;
            }
            case 'z': {
                return width <= 3 ? new CalendarField(10, 3) : null;
            }
            case 'Z': {
                return new CalendarField(9, 5);
            }
        }
        return null;
    }

    public static void putYear4(char[] buf, int off, int year) {
        buf[off] = (char)(year / 1000 + 48);
        buf[off + 1] = (char)(year % 1000 / 100 + 48);
        buf[off + 2] = (char)(year % 100 / 10 + 48);
        buf[off + 3] = (char)(year % 10 + 48);
    }

    public static void putYear2(char[] buf, int off, int year) {
        buf[off] = (char)(year % 100 / 10 + 48);
        buf[off + 1] = (char)(year % 10 + 48);
    }

    public static void putMonth(char[] buf, int off, int month) {
        String s = MONTH_NAMES[month];
        buf[off] = s.charAt(0);
        buf[off + 1] = s.charAt(1);
        buf[off + 2] = s.charAt(2);
    }

    public static void putDayOfWeek(char[] buf, int off, int dayNum) {
        String s = DAY_NAMES[(dayNum + 5) % 7];
        buf[off] = s.charAt(0);
        buf[off + 1] = s.charAt(1);
        buf[off + 2] = s.charAt(2);
    }

    public static void putMillis3(char[] buf, int off, int millis) {
        buf[off] = (char)(millis / 100 + 48);
        buf[off + 1] = (char)(millis % 100 / 10 + 48);
        buf[off + 2] = (char)(millis % 10 + 48);
    }

    public static void putMillis2(char[] buf, int off, int millis) {
        buf[off] = (char)(millis / 100 + 48);
        buf[off + 1] = (char)(millis % 100 / 10 + 48);
    }

    public static void putMillis1(char[] buf, int off, int millis) {
        buf[off] = (char)(millis / 100 + 48);
    }

    public static void putZoneOffset(char[] buf, int off, int zoneOffset) {
        buf[off] = zoneOffset >= 0 ? 43 : 45;
        DateFormatGenerator.putInt(buf, off + 1, zoneOffset / 60);
        DateFormatGenerator.putInt(buf, off + 3, zoneOffset % 60);
    }

    public static void putInt(char[] buf, int off, int n) {
        buf[off] = (char)(n / 10 + 48);
        buf[off + 1] = (char)(n % 10 + 48);
    }

    static class CalendarField {
        final int type;
        final int width;

        CalendarField(int type, int width) {
            this.type = type;
            this.width = width;
        }
    }
}

