/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import one.nio.config.Config;
import one.nio.config.Converter;
import one.nio.net.ConnectionString;
import one.nio.net.SslConfig;
import one.nio.server.AcceptorConfig;

@Config
public class ServerConfig {
    public AcceptorConfig[] acceptors;
    public int selectors;
    public boolean affinity;
    public int minWorkers;
    public int maxWorkers;
    @Converter(method="time")
    public @Converter(method="time") int queueTime;
    @Converter(method="time")
    public @Converter(method="time") int keepAlive;
    public int threadPriority = 5;

    public ServerConfig() {
    }

    private ServerConfig(ConnectionString conn) {
        AcceptorConfig ac = new AcceptorConfig();
        ac.address = conn.getHost();
        ac.port = conn.getPort();
        ac.recvBuf = conn.getIntParam("recvBuf", 0);
        ac.sendBuf = conn.getIntParam("sendBuf", 0);
        ac.tos = conn.getIntParam("tos", 0);
        ac.backlog = conn.getIntParam("backlog", 128);
        if ("ssl".equals(conn.getProtocol())) {
            ac.ssl = SslConfig.from(System.getProperties());
        }
        this.acceptors = new AcceptorConfig[]{ac};
        this.selectors = conn.getIntParam("selectors", 0);
        this.minWorkers = conn.getIntParam("minWorkers", 0);
        this.maxWorkers = conn.getIntParam("maxWorkers", 0);
        this.queueTime = conn.getIntParam("queueTime", 0) / 1000;
        this.threadPriority = conn.getIntParam("threadPriority", 5);
    }

    public static ServerConfig from(String conn) {
        return new ServerConfig(new ConnectionString(conn));
    }

    public static ServerConfig from(ConnectionString conn) {
        return new ServerConfig(conn);
    }
}

