/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import one.nio.serial.DataStream;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;

public class SerializerCollector
extends DataStream {
    private final HashSet<Serializer> serializers = new HashSet();

    public SerializerCollector(byte[] array) {
        super(array);
    }

    public SerializerCollector(long address, long length) {
        super(null, address, length);
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public Set<Serializer> serializers() {
        return this.serializers;
    }

    public long[] uids() {
        long[] result = new long[this.serializers.size()];
        int i = 0;
        for (Serializer serializer : this.serializers) {
            result[i++] = serializer.uid;
        }
        return result;
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        Serializer serializer;
        byte b = this.readByte();
        if (b >= 0) {
            --this.offset;
            serializer = Repository.requestSerializer(this.readLong());
            this.serializers.add(serializer);
        } else {
            if (b == -1) {
                return null;
            }
            if (b == -2) {
                this.offset += 2L;
                return null;
            }
            if (b == -3) {
                this.offset += 4L;
                return null;
            }
            serializer = Repository.requestBootstrapSerializer(b);
        }
        serializer.skip(this);
        return null;
    }
}

