/*
 * Decompiled with CFR 0.152.
 */
package one.nio.rpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.RejectedExecutionException;
import one.nio.http.Request;
import one.nio.net.ProxyProtocol;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.rpc.RemoteCall;
import one.nio.rpc.RpcPacket;
import one.nio.rpc.RpcServer;
import one.nio.rpc.stream.RpcStreamImpl;
import one.nio.rpc.stream.StreamProxy;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.DeserializeStream;
import one.nio.serial.Repository;
import one.nio.serial.SerializeStream;
import one.nio.serial.SerializerNotFoundException;
import one.nio.util.Utf8;

public class RpcSession<S, M>
extends Session {
    protected static final int BUFFER_SIZE = 8000;
    protected static final byte HTTP_REQUEST_UID = (byte)Repository.get(Request.class).uid();
    protected final RpcServer<S> server;
    protected InetSocketAddress peer;
    protected boolean proxyProtocol;
    protected byte[] buffer;
    protected int bytesRead;
    protected int requestSize;
    protected long requestStartTime;

    public RpcSession(Socket socket, RpcServer<S> server) {
        super(socket);
        this.server = server;
        this.peer = socket.getRemoteAddress();
        this.buffer = new byte[8000];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRead(byte[] unusedBuffer) throws Exception {
        Object request;
        byte[] buffer = this.buffer;
        int requestSize = this.requestSize;
        if (requestSize == 0) {
            if (this.proxyProtocol) {
                this.parseProxyProtocol();
            }
            if (this.bytesRead < 4 && (this.bytesRead += super.read(buffer, this.bytesRead, 4 - this.bytesRead)) < 4) {
                return;
            }
            requestSize = RpcPacket.getSize(buffer);
            if (requestSize >= 1195725856 && RpcPacket.isHttpHeader(requestSize)) {
                requestSize = this.readHttpHeader();
                if (requestSize < 0) {
                    return;
                }
            } else {
                this.bytesRead = 0;
            }
            RpcPacket.checkReadSize(requestSize, this.socket);
            if (requestSize > buffer.length) {
                this.buffer = buffer = this.expandBuffer(requestSize);
            }
            this.requestSize = requestSize;
            this.requestStartTime = this.selector.lastWakeupTime();
        }
        if ((this.bytesRead += super.read(buffer, this.bytesRead, requestSize - this.bytesRead)) < requestSize) {
            return;
        }
        M meta = this.onRequestRead();
        this.bytesRead = 0;
        this.requestSize = 0;
        try {
            request = new DeserializeStream(buffer, requestSize).readObject();
        }
        catch (SerializerNotFoundException e) {
            this.writeResponse(e);
            return;
        }
        catch (Exception e) {
            this.handleDeserializationException(e);
            this.server.incRequestsRejected();
            return;
        }
        finally {
            if (requestSize > 8000) {
                this.buffer = new byte[8000];
            }
        }
        if (this.isAsyncRequest(request)) {
            try {
                this.server.asyncExecute(new AsyncRequest(request, meta));
                this.server.incRequestsProcessed();
            }
            catch (RejectedExecutionException e) {
                this.handleRejectedExecution(e, request);
                this.server.incRequestsRejected();
            }
        } else {
            this.invoke(request, meta);
            this.server.incRequestsProcessed();
        }
    }

    private void parseProxyProtocol() throws IOException {
        InetSocketAddress originalAddress = ProxyProtocol.parse(this.socket, this.buffer);
        if (originalAddress != null) {
            this.peer = originalAddress;
        }
        this.proxyProtocol = false;
    }

    private byte[] expandBuffer(int requestSize) {
        byte[] newBuffer = new byte[requestSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.bytesRead);
        return newBuffer;
    }

    private int readHttpHeader() throws IOException {
        byte[] buffer = this.buffer;
        int bytesRead = this.bytesRead;
        bytesRead += super.read(buffer, bytesRead, 8000 - bytesRead);
        this.bytesRead = bytesRead;
        int contentLength = 0;
        int lineStart = 4;
        for (int i = 4; i < bytesRead; ++i) {
            if (buffer[i] != 10) continue;
            if (buffer[i - 1] == 10 || buffer[i - 1] == 13 && buffer[i - 2] == 10) {
                buffer[0] = HTTP_REQUEST_UID;
                return i + 1 + contentLength;
            }
            if (i - lineStart > 16 && RpcSession.startsWith(buffer, lineStart, "content-length: ")) {
                int end = buffer[i - 1] == 13 ? i - 1 : i;
                contentLength = (int)Utf8.parseLong(buffer, lineStart + 16, end - (lineStart + 16));
            }
            lineStart = i + 1;
        }
        return bytesRead < 8000 ? -1 : Integer.MAX_VALUE;
    }

    private static boolean startsWith(byte[] buffer, int from, String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if ((buffer[from + i] | 0x20) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAsyncRequest(Object request) {
        return this.server.getWorkersUsed();
    }

    protected M onRequestRead() {
        return null;
    }

    protected int writeResponse(Object response) throws IOException {
        CalcSizeStream css = new CalcSizeStream();
        css.writeObject(response);
        int responseSize = css.count();
        RpcPacket.checkWriteSize(responseSize);
        byte[] buffer = new byte[responseSize + 4];
        DataStream ds = css.hasCycles() ? new SerializeStream(buffer) : new DataStream(buffer);
        ds.writeInt(responseSize);
        ds.writeObject(response);
        super.write(buffer, 0, buffer.length);
        return responseSize;
    }

    protected void streamCommunicate(StreamProxy streamProxy) throws IOException {
        if (this.selector != null) {
            this.selector.disable(this);
        }
        this.socket.setBlocking(true);
        this.socket.setTos(8);
        this.socket.writeFully(RpcPacket.STREAM_HEADER_ARRAY, 0, 4);
        try (RpcStreamImpl stream = new RpcStreamImpl(this.socket);){
            streamProxy.handler.communicate(stream);
            streamProxy.bytesRead = stream.getBytesRead();
            streamProxy.bytesWritten = stream.getBytesWritten();
        }
        catch (ClassNotFoundException e) {
            this.close();
            throw new IOException(e);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        this.socket.setTos(0);
        this.socket.setBlocking(false);
        if (this.selector != null) {
            this.selector.enable(this);
        }
    }

    protected void invoke(Object request, M meta) throws Exception {
        RemoteCall remoteCall = (RemoteCall)request;
        Object response = remoteCall.method().invoke(this.server.service, remoteCall.args());
        if (response instanceof StreamProxy) {
            this.streamCommunicate((StreamProxy)response);
        } else {
            this.writeResponse(response);
        }
    }

    protected void handleDeserializationException(Exception e) throws IOException {
        this.writeResponse(e);
        log.error((Object)("Cannot deserialize request from " + this.getRemoteHost()), (Throwable)e);
    }

    protected void handleRejectedExecution(RejectedExecutionException e, Object request) throws IOException {
        this.writeResponse(e);
        log.error((Object)("RejectedExecutionException for request: " + request));
    }

    private class AsyncRequest
    implements Runnable {
        private final Object request;
        private final M meta;

        AsyncRequest(Object request, M meta) {
            this.request = request;
            this.meta = meta;
        }

        @Override
        public void run() {
            try {
                RpcSession.this.invoke(this.request, this.meta);
            }
            catch (Throwable e) {
                RpcSession.this.handleException(e);
            }
        }
    }
}

