/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.systemd;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import one.nio.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemdNotify {
    private static final Log log = LogFactory.getLog(SystemdNotify.class);
    public static final String NOTIFY_SOCKET_ENV = "NOTIFY_SOCKET";
    public static final String READY = "READY=1";
    public static final String RELOADING = "RELOADING=1";
    public static final String STOPPING = "STOPPING=1";
    public static final String STATUS = "STATUS=%s";
    public static final String ERRNO = "ERRNO=%d";
    public static final String BUSERROR = "BUSERROR=%s";
    public static final String MAINPID = "MAINPID=%d";
    public static final String WATCHDOG = "WATCHDOG=1";
    public static final String WATCHDOG_TRIGGER = "WATCHDOG=trigger";
    public static final String WATCHDOG_USEC = "WATCHDOG_USEC=%d";
    public static final String EXTEND_TIMEOUT_USEC = "EXTEND_TIMEOUT_USEC=%d";

    public static void notify(String state) throws IOException {
        String notifySocket = System.getenv(NOTIFY_SOCKET_ENV);
        if (notifySocket == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"NOTIFY_SOCKET environment variable is not defined");
            }
            return;
        }
        try (Socket socket = Socket.createUnixSocket();){
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("send '%s' to notify socket '%s'", state, notifySocket));
            }
            ByteBuffer buffer = ByteBuffer.wrap(state.getBytes(StandardCharsets.UTF_8));
            socket.send(buffer, 0, notifySocket, -1);
        }
    }

    public static void ready() throws IOException {
        SystemdNotify.notify(READY);
    }

    public static void reloading() throws IOException {
        SystemdNotify.notify(RELOADING);
    }

    public static void stopping() throws IOException {
        SystemdNotify.notify(STOPPING);
    }

    public static void status(String text) throws IOException {
        SystemdNotify.notify(String.format(STATUS, text));
    }

    public static void errno(int errno) throws IOException {
        SystemdNotify.notify(String.format(ERRNO, errno));
    }

    public static void busError(String error) throws IOException {
        SystemdNotify.notify(String.format(BUSERROR, error));
    }

    public static void mainPid(int pid) throws IOException {
        SystemdNotify.notify(String.format(MAINPID, pid));
    }

    public static void watchdog() throws IOException {
        SystemdNotify.notify(WATCHDOG);
    }

    public static void watchdogTrigger() throws IOException {
        SystemdNotify.notify(WATCHDOG_TRIGGER);
    }

    public static void watchdogUsec(int usec) throws IOException {
        SystemdNotify.notify(String.format(WATCHDOG_USEC, usec));
    }

    public static void extendTimeoutUsec(int usec) throws IOException {
        SystemdNotify.notify(String.format(EXTEND_TIMEOUT_USEC, usec));
    }
}

