/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.async.AsyncExecutor;
import one.nio.async.ParallelTask;
import one.nio.mem.DirectMemory;
import one.nio.mem.Malloc;
import one.nio.mem.MallocMT;
import one.nio.mem.MappedFile;
import one.nio.mem.OffheapMap;
import one.nio.mem.SharedMemoryMapMXBean;
import one.nio.mgt.Management;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DeserializeStream;
import one.nio.serial.Repository;
import one.nio.serial.SerializeStream;
import one.nio.serial.Serializer;
import one.nio.serial.SerializerCollector;
import one.nio.serial.SerializerNotFoundException;

public abstract class SharedMemoryMap<K, V>
extends OffheapMap<K, V>
implements SharedMemoryMapMXBean {
    protected static final long SIGNATURE_CLEAR = -6842623370938455949L;
    protected static final long SIGNATURE_LEGACY = -6842904845915166605L;
    protected static final long SIGNATURE_DIRTY = -6842622284294952845L;
    protected static final long SIGNATURE_OFFSET = 0L;
    protected static final long TIMESTAMP_OFFSET = 8L;
    protected static final long CAPACITY_OFFSET = 16L;
    protected static final long BASE_OFFSET = 24L;
    protected static final long UID_OFFSET = 32L;
    protected static final long CUSTOM_SIZE_OFFSET = 40L;
    protected static final long CUSTOM_DATA_OFFSET = 48L;
    protected static final long MAP_OFFSET = 0x100000L;
    protected static final int MAX_CUSTOM_DATA_SIZE = 1048528;
    protected final String className;
    protected final MappedFile mmap;
    protected final String name;
    protected MallocMT allocator;
    protected Serializer<V> serializer;

    protected SharedMemoryMap(int capacity, String fileName, long fileSize) throws IOException {
        this(capacity, fileName, fileSize, 0L);
    }

    protected SharedMemoryMap(int capacity, String fileName, long fileSize, long expirationTime) throws IOException {
        super(capacity);
        String className = this.getClass().getName();
        this.className = className.substring(className.lastIndexOf(46) + 1);
        if (fileName == null || fileName.isEmpty()) {
            this.mmap = new MappedFile(fileSize);
            this.name = "anon." + Long.toHexString(this.mmap.getAddr());
        } else {
            this.mmap = new MappedFile(fileName, fileSize);
            this.name = fileName;
        }
        long mallocOffset = 0x100000L + (long)this.capacity * 8L;
        if (this.mmap.getSize() <= mallocOffset) {
            long minSize = (mallocOffset + 1048575L) / 0x100000L;
            throw new IllegalArgumentException("Minimum " + className + " size is " + minSize + " MB");
        }
        this.init(expirationTime);
        this.createAllocator(this.mmap.getAddr() + mallocOffset, this.mmap.getSize() - mallocOffset);
        Management.registerMXBean(this, "one.nio.mem:type=SharedMemoryMap,name=" + this.name);
    }

    @Override
    protected void closeInternal() {
        Management.unregisterMXBean("one.nio.mem:type=SharedMemoryMap,name=" + this.name);
        this.storeSchema();
        this.setHeader(8L, System.currentTimeMillis());
        this.setHeader(0L, -6842623370938455949L);
        this.mmap.close();
        log.info((Object)(this.className + " gracefully closed"));
    }

    private void init(long expirationTime) {
        if (this.needCleanup(expirationTime)) {
            DirectMemory.clear(this.mmap.getAddr(), this.mmap.getSize());
            this.setHeader(16L, this.capacity);
        }
        this.setHeader(0L, -6842622284294952845L);
        this.mapBase = this.mmap.getAddr() + 0x100000L;
        long oldBase = this.getHeader(24L);
        if (oldBase != 0L) {
            log.info((Object)("Relocating " + this.className + "..."));
            this.relocate(this.mmap.getAddr() - oldBase);
        }
        this.setHeader(24L, this.mmap.getAddr());
    }

    protected boolean needCleanup(long expirationTime) {
        long signature = this.getHeader(0L);
        if (signature == -6842622284294952845L) {
            log.info((Object)("Resetting dirty " + this.className + "..."));
            return true;
        }
        if (signature == -6842904845915166605L) {
            log.info((Object)("Converting " + this.className + " from legacy format..."));
        } else if (signature != -6842623370938455949L) {
            log.info((Object)("Initial cleanup of " + this.className + "..."));
            return true;
        }
        if (this.getHeader(8L) < expirationTime) {
            log.info((Object)(this.className + " expired, performing cleanup..."));
            return true;
        }
        if (this.getHeader(16L) != (long)this.capacity) {
            log.info((Object)(this.className + " capacity has changed, performing cleanup..."));
            return true;
        }
        return false;
    }

    protected void relocate(long delta) {
        int count = 0;
        for (int i = 0; i < this.capacity; ++i) {
            long entry;
            long currentPtr = this.mapBase + (long)i * 8L;
            while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
                unsafe.putAddress(currentPtr, entry += delta);
                ++count;
                currentPtr = entry + 8L;
            }
        }
        this.count.set(count);
    }

    protected long getHeader(long offset) {
        return unsafe.getLong(this.mmap.getAddr() + offset);
    }

    protected void setHeader(long offset, long value) {
        unsafe.putLong(this.mmap.getAddr() + offset, value);
    }

    protected byte[] getCustomData() {
        byte[] data = new byte[(int)this.getHeader(40L)];
        unsafe.copyMemory(null, this.mmap.getAddr() + 48L, data, byteArrayOffset, data.length);
        return data;
    }

    protected void setCustomData(byte[] data) {
        if (data.length > 1048528) {
            throw new IllegalArgumentException("Custom data too long");
        }
        this.setHeader(40L, data.length);
        unsafe.copyMemory(data, byteArrayOffset, null, this.mmap.getAddr() + 48L, data.length);
    }

    @Override
    protected long allocateEntry(K key, long hashCode, int size) {
        return this.allocator.segmentFor(hashCode).malloc(24 + size);
    }

    @Override
    protected void destroyEntry(long entry) {
        this.allocator.free(entry);
    }

    @Override
    protected int sizeOf(long entry) {
        return this.allocator.allocatedSize(entry) - this.headerSize(entry);
    }

    @Override
    protected V valueAt(long entry) {
        try {
            long valueAddress = entry + (long)this.headerSize(entry);
            return this.serializer.read(new DeserializeStream(valueAddress, Integer.MAX_VALUE));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void setValueAt(long entry, V value) {
        try {
            long valueAddress = entry + (long)this.headerSize(entry);
            this.serializer.write(value, new SerializeStream(valueAddress, Integer.MAX_VALUE));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected int sizeOf(V value) {
        try {
            CalcSizeStream css = new CalcSizeStream();
            this.serializer.calcSize(value, css);
            return css.count();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected int headerSize(long entry) {
        return 24;
    }

    @Override
    public long getTotalMemory() {
        return this.allocator.getTotalMemory();
    }

    @Override
    public long getFreeMemory() {
        return this.allocator.getFreeMemory();
    }

    @Override
    public long getUsedMemory() {
        return this.allocator.getUsedMemory();
    }

    @Override
    public int entriesToClean() {
        long freeMemory;
        long totalMemory = this.getTotalMemory();
        long exceededMemory = (long)((double)totalMemory * this.cleanupThreshold) - (freeMemory = this.getFreeMemory());
        if (exceededMemory > 0L && totalMemory > freeMemory) {
            return (int)((long)this.getCount() * exceededMemory / (totalMemory - freeMemory));
        }
        return 0;
    }

    protected void createAllocator(long startAddress, long totalMemory) {
        this.allocator = new MallocMT(startAddress, totalMemory);
        log.info((Object)(this.className + " initialized: capacity = " + this.getCount() + "/" + this.getCapacity() + ", memory = " + this.allocator.getUsedMemory() / 0x100000L + "/" + this.allocator.getTotalMemory() / 0x100000L + " MB"));
    }

    public void setSerializer(Class<V> valueType) throws IOException {
        this.serializer = Repository.get(valueType);
        this.loadSchema();
    }

    public void setSerializer(Serializer<V> serializer) throws IOException {
        this.serializer = serializer;
        this.loadSchema();
    }

    protected void loadSchema() throws IOException {
        log.info((Object)("Loading serialization schema for " + this.className + "..."));
        Repository.get(this.serializer.getClass());
        long metadataSize = this.getHeader(40L);
        if (metadataSize < 0L || metadataSize > 1048528L) {
            throw new IllegalStateException("Invalid metadata size: " + metadataSize);
        }
        int count = 0;
        DeserializeStream ds = new DeserializeStream(this.mmap.getAddr() + 48L, metadataSize);
        while (ds.available() > 0) {
            try {
                Repository.provideSerializer((Serializer)ds.readObject());
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            ++count;
        }
        log.info((Object)("Loaded " + count + " serializers for " + this.className));
        long oldUid = this.getHeader(32L);
        if (oldUid != 0L && oldUid != this.serializer.uid()) {
            this.convert(this.findSerializer(oldUid), this.serializer);
        }
    }

    protected void storeSchema() {
        if (this.serializer == null) {
            return;
        }
        log.info((Object)("Saving serialization schema for " + this.className + "..."));
        final HashSet<Serializer<V>> serializers = new HashSet<Serializer<V>>();
        if (this.serializer.uid() >= 0L) {
            serializers.add(this.serializer);
        }
        AsyncExecutor.fork(new ParallelTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(int taskNum, int taskCount) throws IOException, ClassNotFoundException {
                SerializerCollector collector = new SerializerCollector(SharedMemoryMap.this.mmap.getAddr(), SharedMemoryMap.this.mmap.getSize());
                for (int i = taskNum; i < SharedMemoryMap.this.capacity; i += taskCount) {
                    long entry;
                    long currentPtr = SharedMemoryMap.this.mapBase + (long)i * 8L;
                    while ((entry = OffheapMap.unsafe.getAddress(currentPtr)) != 0L) {
                        collector.setOffset(entry + (long)SharedMemoryMap.this.headerSize(entry));
                        SharedMemoryMap.this.serializer.read(collector);
                        currentPtr = entry + 8L;
                    }
                }
                HashSet hashSet = serializers;
                synchronized (hashSet) {
                    serializers.addAll(collector.serializers());
                }
            }
        });
        SerializeStream ss = new SerializeStream(this.mmap.getAddr() + 48L, 1048528L);
        try {
            for (Serializer serializer : serializers) {
                ss.writeObject(serializer);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.setHeader(32L, this.serializer.uid());
        this.setHeader(40L, ss.count());
        log.info((Object)("Stored " + serializers.size() + " serializers for " + this.className + ". Metadata size = " + ss.count()));
    }

    protected void convert(final Serializer<V> oldSerializer, final Serializer<V> newSerializer) {
        log.info((Object)("Main serializer mismatch. Will run in-memory conversion for " + this.className + "."));
        log.info((Object)("Old serializer:\n" + oldSerializer + "New serializer:\n" + newSerializer));
        long startTime = System.currentTimeMillis();
        long startFreeMemory = this.allocator.getFreeMemory();
        final AtomicInteger totalConverted = new AtomicInteger();
        AsyncExecutor.fork(this.allocator.segments(), new ParallelTask(){

            @Override
            public void execute(int taskNum, int taskCount) throws IOException, ClassNotFoundException {
                Malloc localAllocator = SharedMemoryMap.this.allocator.segment(taskNum);
                int converted = 0;
                for (int i = taskNum; i < SharedMemoryMap.this.capacity; i += taskCount) {
                    long entry;
                    long currentPtr = SharedMemoryMap.this.mapBase + (long)i * 8L;
                    while ((entry = OffheapMap.unsafe.getAddress(currentPtr)) != 0L) {
                        int headerSize = SharedMemoryMap.this.headerSize(entry);
                        Object value = oldSerializer.read(new DeserializeStream(entry + (long)headerSize, Integer.MAX_VALUE));
                        int oldSize = SharedMemoryMap.this.sizeOf(entry);
                        int newSize = SharedMemoryMap.this.sizeOf(value);
                        if (newSize > oldSize) {
                            long newEntry = localAllocator.malloc(headerSize + newSize);
                            OffheapMap.unsafe.copyMemory(null, entry, null, newEntry, headerSize);
                            OffheapMap.unsafe.putAddress(currentPtr, newEntry);
                            SharedMemoryMap.this.allocator.free(entry);
                            entry = newEntry;
                        }
                        newSerializer.write(value, new SerializeStream(entry + (long)headerSize, Integer.MAX_VALUE));
                        ++converted;
                        currentPtr = entry + 8L;
                    }
                }
                totalConverted.addAndGet(converted);
            }
        });
        long endFreeMemory = this.allocator.getFreeMemory();
        long endTime = System.currentTimeMillis();
        log.info((Object)("Converted " + totalConverted.get() + " objects in " + (endTime - startTime) + " ms. Memory delta = " + (endFreeMemory - startFreeMemory)));
    }

    private Serializer<V> findSerializer(long uid) throws SerializerNotFoundException {
        return Repository.requestSerializer(uid);
    }
}

