/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.io.ObjectOutput;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import one.nio.util.Utf8;

public class DigestStream
implements ObjectOutput {
    protected MessageDigest md;
    protected byte[] buf;

    public DigestStream(String algorithm) {
        try {
            this.md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        this.buf = new byte[8];
    }

    public long digest() {
        byte[] tmp = this.md.digest();
        return ((long)tmp[0] & 0x7FL) << 56 | ((long)tmp[1] & 0xFFL) << 48 | ((long)tmp[2] & 0xFFL) << 40 | ((long)tmp[3] & 0xFFL) << 32 | ((long)tmp[4] & 0xFFL) << 24 | ((long)tmp[5] & 0xFFL) << 16 | ((long)tmp[6] & 0xFFL) << 8 | (long)tmp[7] & 0xFFL;
    }

    @Override
    public void write(int b) {
        this.md.update((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this.md.update(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.md.update(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.md.update(v ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.md.update((byte)v);
    }

    @Override
    public void writeShort(int v) {
        this.buf[0] = (byte)(v >>> 8);
        this.buf[1] = (byte)v;
        this.md.update(this.buf, 0, 2);
    }

    @Override
    public void writeChar(int v) {
        this.buf[0] = (byte)(v >>> 8);
        this.buf[1] = (byte)v;
        this.md.update(this.buf, 0, 2);
    }

    @Override
    public void writeInt(int v) {
        this.buf[0] = (byte)(v >>> 24);
        this.buf[1] = (byte)(v >>> 16);
        this.buf[2] = (byte)(v >>> 8);
        this.buf[3] = (byte)v;
        this.md.update(this.buf, 0, 4);
    }

    @Override
    public void writeLong(long v) {
        this.buf[0] = (byte)(v >>> 56);
        this.buf[1] = (byte)(v >>> 48);
        this.buf[2] = (byte)(v >>> 40);
        this.buf[3] = (byte)(v >>> 32);
        this.buf[4] = (byte)(v >>> 24);
        this.buf[5] = (byte)(v >>> 16);
        this.buf[6] = (byte)(v >>> 8);
        this.buf[7] = (byte)v;
        this.md.update(this.buf, 0, 8);
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void writeBytes(String s) {
        int length = s.length();
        byte[] tmp = new byte[length];
        s.getBytes(0, length, tmp, length);
        this.md.update(tmp);
    }

    @Override
    public void writeChars(String s) {
        int length = s.length();
        byte[] tmp = new byte[length << 1];
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            char v = s.charAt(i);
            tmp[pos] = (byte)(v >>> 8);
            tmp[pos + 1] = (byte)v;
            pos += 2;
        }
        this.md.update(tmp);
    }

    @Override
    public void writeUTF(String s) {
        int utfLength = Utf8.length(s);
        byte[] tmp = new byte[utfLength + 2];
        tmp[0] = (byte)(utfLength >>> 8);
        tmp[1] = (byte)utfLength;
        Utf8.write(s, tmp, 2);
        this.md.update(tmp);
    }

    @Override
    public void writeObject(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

