/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import one.nio.mgt.Management;
import one.nio.net.Selector;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.server.AcceptorConfig;
import one.nio.server.AcceptorThread;
import one.nio.server.CleanupThread;
import one.nio.server.RejectedSessionException;
import one.nio.server.SelectorThread;
import one.nio.server.ServerConfig;
import one.nio.server.ServerMXBean;
import one.nio.server.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Server
implements ServerMXBean {
    private static final Log log = LogFactory.getLog(Server.class);
    private final AtomicLong requestsProcessed = new AtomicLong();
    private final AtomicLong requestsRejected = new AtomicLong();
    private volatile SelectorStats selectorStats;
    private volatile QueueStats queueStats;
    protected final int port;
    protected final AcceptorThread[] acceptors;
    protected final CountDownLatch startSync;
    protected volatile SelectorThread[] selectors;
    protected final WorkerPool workers;
    protected boolean useWorkers;
    protected final CleanupThread cleanup;

    public Server(ServerConfig config) throws IOException {
        if (config.acceptors == null || config.acceptors.length == 0) {
            throw new IllegalArgumentException("No configured acceptors");
        }
        this.port = config.acceptors[0].port;
        this.acceptors = new AcceptorThread[config.acceptors.length];
        for (int i = 0; i < this.acceptors.length; ++i) {
            this.acceptors[i] = new AcceptorThread(this, config.acceptors[i]);
        }
        this.startSync = new CountDownLatch(this.acceptors.length);
        int processors = Runtime.getRuntime().availableProcessors();
        SelectorThread[] selectors = new SelectorThread[config.selectors != 0 ? config.selectors : processors];
        for (int i = 0; i < selectors.length; ++i) {
            selectors[i] = new SelectorThread(i, config.affinity ? 1L << i % processors : 0L);
            selectors[i].setPriority(config.threadPriority);
        }
        this.selectors = selectors;
        this.useWorkers = config.maxWorkers > 0;
        this.workers = new WorkerPool(config.minWorkers, this.useWorkers ? config.maxWorkers : 2, config.queueTime, config.threadPriority);
        this.cleanup = new CleanupThread(selectors, config.keepAlive);
        this.selectorStats = new SelectorStats();
        this.queueStats = new QueueStats();
    }

    public synchronized void reconfigure(ServerConfig config) throws IOException {
        this.workers.setCorePoolSize(config.minWorkers);
        this.useWorkers = config.maxWorkers > 0;
        this.workers.setMaximumPoolSize(this.useWorkers ? config.maxWorkers : 2);
        this.workers.setQueueTime(config.queueTime);
        block0: for (AcceptorConfig ac : config.acceptors) {
            for (AcceptorThread acceptor : this.acceptors) {
                if (acceptor.port != ac.port || !acceptor.address.equals(ac.address)) continue;
                acceptor.reconfigure(ac);
                continue block0;
            }
        }
        int processors = Runtime.getRuntime().availableProcessors();
        SelectorThread[] selectors = this.selectors;
        if (config.selectors > selectors.length) {
            SelectorThread[] newSelectors = Arrays.copyOf(selectors, config.selectors);
            for (int i = selectors.length; i < config.selectors; ++i) {
                newSelectors[i] = new SelectorThread(i, config.affinity ? 1L << i % processors : 0L);
                newSelectors[i].setPriority(config.threadPriority);
                newSelectors[i].start();
            }
            this.selectors = newSelectors;
        }
        this.cleanup.update(this.selectors, config.keepAlive);
    }

    public synchronized void start() {
        SelectorThread[] selectors = this.selectors;
        for (SelectorThread selectorThread : selectors) {
            selectorThread.start();
        }
        for (Thread thread : this.acceptors) {
            thread.start();
        }
        try {
            this.startSync.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.cleanup.start();
        Management.registerMXBean(this, "one.nio.server:type=Server,port=" + this.port);
    }

    public synchronized void stop() {
        SelectorThread[] selectors;
        Management.unregisterMXBean("one.nio.server:type=Server,port=" + this.port);
        this.cleanup.shutdown();
        for (AcceptorThread acceptor : this.acceptors) {
            acceptor.shutdown();
        }
        for (SelectorThread selector : selectors = this.selectors) {
            selector.shutdown();
        }
        this.workers.gracefulShutdown(30000L);
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("Server Shutdown"){

            @Override
            public void run() {
                log.info((Object)"Server is shutting down...");
                Server.this.stop();
                log.info((Object)"Server stopped");
            }
        });
    }

    protected Session createSession(Socket socket) throws RejectedSessionException {
        return new Session(socket);
    }

    protected void register(Session session) {
        this.getSmallestSelector().register(session);
    }

    private Selector getSmallestSelector() {
        SelectorThread[] selectors = this.selectors;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        Selector a = selectors[r.nextInt((int)selectors.length)].selector;
        Selector b = selectors[r.nextInt((int)selectors.length)].selector;
        return a.size() < b.size() ? a : b;
    }

    public final long incRequestsProcessed() {
        return this.requestsProcessed.incrementAndGet();
    }

    public final long incRequestsRejected() {
        return this.requestsRejected.incrementAndGet();
    }

    @Override
    public int getConnections() {
        SelectorThread[] selectors;
        int result = 0;
        for (SelectorThread selector : selectors = this.selectors) {
            result += selector.selector.size();
        }
        return result;
    }

    @Override
    public long getKeepAlive() {
        return this.cleanup.getKeepAlive();
    }

    @Override
    public boolean getWorkersUsed() {
        return this.useWorkers;
    }

    @Override
    public int getWorkers() {
        return this.workers.getPoolSize();
    }

    @Override
    public int getWorkersActive() {
        return this.workers.getActiveCount();
    }

    @Override
    public long getAcceptedSessions() {
        long result = 0L;
        for (AcceptorThread acceptor : this.acceptors) {
            result += acceptor.acceptedSessions;
        }
        return result;
    }

    @Override
    public long getRejectedSessions() {
        long result = 0L;
        for (AcceptorThread acceptor : this.acceptors) {
            result += acceptor.rejectedSessions;
        }
        return result;
    }

    @Override
    public int getSelectorCount() {
        return this.selectors.length;
    }

    @Override
    public double getSelectorAvgReady() {
        SelectorStats selectorStats = this.getSelectorStats();
        return selectorStats.operations == 0L ? 0.0 : (double)selectorStats.sessions / (double)selectorStats.operations;
    }

    @Override
    public int getSelectorMaxReady() {
        return this.getSelectorStats().maxReady;
    }

    @Override
    public long getSelectorOperations() {
        return this.getSelectorStats().operations;
    }

    @Override
    public long getSelectorSessions() {
        return this.getSelectorStats().sessions;
    }

    @Override
    public double getQueueAvgLength() {
        QueueStats queueStats = this.getQueueStats();
        return queueStats.sessions == 0 ? 0.0 : (double)queueStats.totalLength / (double)queueStats.sessions;
    }

    @Override
    public long getQueueAvgBytes() {
        QueueStats queueStats = this.getQueueStats();
        return queueStats.sessions == 0 ? 0L : queueStats.totalBytes / (long)queueStats.sessions;
    }

    @Override
    public long getQueueMaxLength() {
        return this.getQueueStats().maxLength;
    }

    @Override
    public long getQueueMaxBytes() {
        return this.getQueueStats().maxBytes;
    }

    @Override
    public long getRequestsProcessed() {
        return this.requestsProcessed.get();
    }

    @Override
    public long getRequestsRejected() {
        return this.requestsRejected.get();
    }

    @Override
    public synchronized void reset() {
        SelectorThread[] selectors;
        for (AcceptorThread acceptor : this.acceptors) {
            acceptor.acceptedSessions = 0L;
            acceptor.rejectedSessions = 0L;
        }
        for (SelectorThread selector : selectors = this.selectors) {
            selector.operations = 0L;
            selector.sessions = 0L;
            selector.maxReady = 0;
        }
        this.requestsProcessed.set(0L);
        this.requestsRejected.set(0L);
    }

    public final void asyncExecute(Runnable command) {
        this.workers.execute(command);
    }

    private synchronized SelectorStats getSelectorStats() {
        SelectorThread[] selectors;
        SelectorStats selectorStats = this.selectorStats;
        long currentTime = System.currentTimeMillis();
        if (currentTime < selectorStats.expireTime) {
            return selectorStats;
        }
        selectorStats = new SelectorStats();
        selectorStats.expireTime = currentTime + 1000L;
        for (SelectorThread selector : selectors = this.selectors) {
            selectorStats.operations += selector.operations;
            selectorStats.sessions += selector.sessions;
            selectorStats.maxReady = Math.max(selectorStats.maxReady, selector.maxReady);
        }
        this.selectorStats = selectorStats;
        return selectorStats;
    }

    private synchronized QueueStats getQueueStats() {
        QueueStats queueStats = this.queueStats;
        long currentTime = System.currentTimeMillis();
        if (currentTime < queueStats.expireTime) {
            return queueStats;
        }
        queueStats = new QueueStats();
        queueStats.expireTime = currentTime + 1000L;
        long[] stats = new long[2];
        for (SelectorThread selector : this.selectors) {
            for (Session session : selector.selector) {
                session.getQueueStats(stats);
                ++queueStats.sessions;
                queueStats.totalLength += stats[0];
                queueStats.totalBytes += stats[1];
                if (stats[0] > queueStats.maxLength) {
                    queueStats.maxLength = stats[0];
                }
                if (stats[1] <= queueStats.maxBytes) continue;
                queueStats.maxBytes = stats[1];
            }
        }
        this.queueStats = queueStats;
        return queueStats;
    }

    private static final class QueueStats {
        long expireTime;
        long totalLength;
        long totalBytes;
        long maxLength;
        long maxBytes;
        int sessions;

        private QueueStats() {
        }
    }

    private static final class SelectorStats {
        long expireTime;
        long operations;
        long sessions;
        int maxReady;

        private SelectorStats() {
        }
    }
}

