/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.Externalizable;
import java.io.IOException;
import one.nio.serial.DataStream;
import one.nio.serial.ExternalizableSerializer;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.util.JavaInternals;

class SerializerSerializer
extends ExternalizableSerializer {
    SerializerSerializer(Class cls) {
        super(cls);
    }

    @Override
    public Serializer read(DataStream in) throws IOException, ClassNotFoundException {
        String descriptor = in.readUTF();
        long uid = in.readLong();
        Serializer serializer = Repository.uidMap.get(uid);
        if (serializer != null) {
            if (!descriptor.equals(serializer.descriptor)) {
                throw new IllegalStateException("UID collision: " + descriptor + " overwrites " + serializer.descriptor);
            }
            in.register(serializer);
            serializer.skipExternal(in);
            return serializer;
        }
        try {
            serializer = (Serializer)JavaInternals.unsafe.allocateInstance(this.cls);
            serializer.descriptor = descriptor;
            serializer.uid = uid;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        in.register(serializer);
        serializer.readExternal(in);
        return serializer;
    }

    @Override
    public void toJson(Externalizable obj, StringBuilder builder) {
        ((Serializer)obj).toJson(builder);
    }
}

