/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.DeserializeStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Origin;
import one.nio.serial.PersistStream;
import one.nio.serial.SerializeStream;
import one.nio.serial.TypeDescriptor;
import one.nio.util.DigestStream;

public abstract class Serializer<T>
implements Externalizable {
    protected String descriptor;
    protected long uid;
    protected Class cls;
    protected Origin origin;

    protected Serializer(Class cls) {
        this.descriptor = TypeDescriptor.classDescriptor(cls);
        this.cls = cls;
        this.origin = Origin.LOCAL;
    }

    public long uid() {
        return this.uid;
    }

    public Class<T> cls() {
        return this.cls;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.descriptor);
        out.writeLong(this.uid);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cls = TypeDescriptor.resolve(this.descriptor);
        this.origin = Origin.EXTERNAL;
    }

    public void skipExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public byte[] code() {
        return null;
    }

    protected final String uniqueName(String prefix) {
        int p = this.descriptor.indexOf(124);
        String className = p < 0 ? this.descriptor : this.descriptor.substring(0, p);
        String simpleName = className.substring(className.lastIndexOf(46) + 1);
        return prefix + '$' + Long.toHexString(this.uid) + '$' + simpleName;
    }

    protected final void generateUid() {
        if (this.uid == 0L) {
            try (DigestStream ds = new DigestStream("MD5");){
                ds.writeUTF(this.getClass().getName());
                this.writeExternal(ds);
                this.uid = ds.digest();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void toJson(StringBuilder sb) {
        sb.append("{\"cls\":\"").append(this.descriptor).append("\",\"uid\":").append(this.uid).append('}');
    }

    public String toString() {
        return "Class: " + this.descriptor + '\n' + "UID: " + Long.toHexString(this.uid) + '\n' + "Origin: " + (Object)((Object)this.origin) + '\n';
    }

    public boolean equals(Object obj) {
        if (obj instanceof Serializer) {
            Serializer other = (Serializer)obj;
            return this.uid == other.uid && this.descriptor.equals(other.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.uid ^ (int)(this.uid >>> 32);
    }

    public abstract void calcSize(T var1, CalcSizeStream var2) throws IOException;

    public abstract void write(T var1, DataStream var2) throws IOException;

    public abstract T read(DataStream var1) throws IOException, ClassNotFoundException;

    public abstract void skip(DataStream var1) throws IOException, ClassNotFoundException;

    public abstract void toJson(T var1, StringBuilder var2) throws IOException;

    public abstract T fromJson(JsonReader var1) throws IOException, ClassNotFoundException;

    public T fromString(String s) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.descriptor);
    }

    public static int sizeOf(Object obj) throws IOException {
        CalcSizeStream css = new CalcSizeStream();
        css.writeObject(obj);
        return css.count;
    }

    public static byte[] serialize(Object obj) throws IOException {
        CalcSizeStream css = new CalcSizeStream();
        css.writeObject(obj);
        byte[] data = new byte[css.count];
        DataStream ds = css.hasCycles ? new SerializeStream(data) : new DataStream(data);
        ds.writeObject(obj);
        return data;
    }

    public static byte[] persist(Object obj) throws IOException {
        PersistStream ps = new PersistStream();
        ps.writeObject(obj);
        return ps.toByteArray();
    }

    public static Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        return new DeserializeStream(data).readObject();
    }
}

