/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import one.nio.serial.Renamed;
import one.nio.serial.SerializeWith;
import one.nio.serial.TypeDescriptor;

public class FieldDescriptor {
    private String nameDescriptor;
    private TypeDescriptor typeDescriptor;
    private Field ownField;
    private Field parentField;
    private boolean useGetter;
    private boolean useSetter;
    public FieldDescriptor next;

    FieldDescriptor(String nameDescriptor, TypeDescriptor typeDescriptor) {
        this.nameDescriptor = nameDescriptor;
        this.typeDescriptor = typeDescriptor;
    }

    FieldDescriptor(Field ownField, Field parentField) {
        Renamed renamed = ownField.getAnnotation(Renamed.class);
        this.nameDescriptor = renamed == null ? ownField.getName() : ownField.getName() + '|' + renamed.from();
        this.typeDescriptor = new TypeDescriptor(ownField.getType());
        this.assignField(ownField, parentField);
    }

    public String toString() {
        return this.nameDescriptor + ':' + this.typeDescriptor.toString();
    }

    public String name() {
        return this.nameDescriptor;
    }

    public TypeDescriptor type() {
        return this.typeDescriptor;
    }

    public Field ownField() {
        return this.ownField;
    }

    public Field parentField() {
        return this.parentField;
    }

    public boolean useGetter() {
        return this.useGetter;
    }

    public boolean useSetter() {
        return this.useSetter;
    }

    public boolean is(String nameDescriptor, String typeDescriptor) {
        return nameDescriptor.equals(this.nameDescriptor) && typeDescriptor.equals(this.typeDescriptor.toString());
    }

    public void assignField(Field ownField, Field parentField) {
        this.ownField = ownField;
        this.parentField = parentField;
        SerializeWith serializeWith = ownField.getAnnotation(SerializeWith.class);
        if (serializeWith != null) {
            this.useGetter = !serializeWith.getter().isEmpty();
            this.useSetter = !serializeWith.setter().isEmpty();
        }
    }

    public static FieldDescriptor read(ObjectInput in) throws IOException {
        String nameDescriptor = in.readUTF();
        TypeDescriptor typeDescriptor = TypeDescriptor.read(in);
        return new FieldDescriptor(nameDescriptor, typeDescriptor);
    }

    public void write(ObjectOutput out) throws IOException {
        out.writeUTF(this.nameDescriptor);
        this.typeDescriptor.write(out);
    }
}

