/*
 * Decompiled with CFR 0.152.
 */
package one.nio.rpc.stream;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import one.nio.net.Socket;
import one.nio.rpc.stream.BidiStream;
import one.nio.rpc.stream.RpcStream;
import one.nio.serial.ObjectInputChannel;
import one.nio.serial.ObjectOutputChannel;

public class RpcStreamImpl<S, R>
implements RpcStream,
BidiStream<S, R> {
    protected final Socket socket;
    protected final ObjectInputChannel in;
    protected final ObjectOutputChannel out;
    protected boolean error;

    public RpcStreamImpl(Socket socket) {
        this.socket = socket;
        this.in = new ObjectInputChannel(socket);
        this.out = new ObjectOutputChannel(socket);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.socket.getRemoteAddress();
    }

    @Override
    public long getBytesRead() {
        return this.in.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.out.getBytesWritten();
    }

    @Override
    public void read(ByteBuffer buf) throws IOException {
        try {
            this.in.read(buf);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        try {
            Object result = this.in.readObject();
            this.in.reset();
            return result;
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.in.read();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            return this.in.read(b);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.in.read(b, off, len);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.in.skip(n);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public int available() {
        return this.in.available();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        try {
            this.in.readFully(b);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.in.read(b, off, len);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        try {
            return this.in.skipBytes(n);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            return this.in.readBoolean();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.in.readByte();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        try {
            return this.in.readUnsignedByte();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.in.readShort();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        try {
            return this.in.readUnsignedShort();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public char readChar() throws IOException {
        try {
            return this.in.readChar();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.in.readInt();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.in.readLong();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.in.readFloat();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.in.readDouble();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public String readLine() throws IOException {
        try {
            return this.in.readLine();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public String readUTF() throws IOException {
        try {
            return this.in.readUTF();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void write(ByteBuffer buf) throws IOException {
        try {
            this.out.write(buf);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        try {
            this.out.writeObject(obj);
            this.out.reset();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.out.write(b);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.out.write(b);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.out.write(b, off, len);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        try {
            this.out.writeBoolean(v);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        try {
            this.out.writeByte(v);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        try {
            this.out.writeShort(v);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        try {
            this.out.writeChar(v);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        try {
            this.out.writeInt(v);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        try {
            this.out.writeLong(v);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        try {
            this.out.writeFloat(v);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        try {
            this.out.writeDouble(v);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        try {
            this.out.writeBytes(s);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        try {
            this.out.writeChars(s);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        try {
            this.out.writeUTF(s);
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (Throwable e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    @Override
    public R receive() throws IOException, ClassNotFoundException {
        return (R)this.readObject();
    }

    @Override
    public void send(S object) throws IOException {
        this.writeObject(object);
    }

    @Override
    public R sendAndGet(S object) throws IOException, ClassNotFoundException {
        this.writeObject(object);
        this.flush();
        return (R)this.readObject();
    }
}

