/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import one.nio.os.NativeLibrary;
import one.nio.os.perf.PerfCounter;
import one.nio.os.perf.PerfCounterGlobal;
import one.nio.os.perf.PerfEvent;
import one.nio.os.perf.PerfOption;

public class Perf {
    public static final boolean IS_SUPPORTED = NativeLibrary.IS_SUPPORTED && new File("/proc/sys/kernel/perf_event_paranoid").exists();
    private static final int REAL_CPU_COUNT = Perf.getRealCpuCount();
    public static final int CURRENT_PID = 0;
    public static final int ANY_PID = -1;
    public static final int ANY_CPU = -1;
    static final int IOCTL_RESET = 0;
    static final int IOCTL_ENABLE = 1;
    static final int IOCTL_DISABLE = 2;
    static final int IOCTL_REFRESH = 3;

    public static PerfCounter open(PerfEvent event, int pid, int cpu, PerfOption ... options) throws IOException {
        if (cpu == -1 && (pid == -1 || Perf.hasOption(options, PerfOption.PID_CGROUP))) {
            return Perf.openGlobal(event, pid, options);
        }
        int fd = Perf.openEvent(pid, cpu, event.type, event.config, event.breakpoint, -1, Perf.optionString(options));
        return new PerfCounter(event, fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerfCounter open(PerfEvent event, String cgroup, int cpu, PerfOption ... options) throws IOException {
        options = Arrays.copyOf(options, options.length + 1);
        options[options.length - 1] = PerfOption.PID_CGROUP;
        int fd = Perf.openFile("/sys/fs/cgroup/perf_event/" + cgroup);
        try {
            PerfCounter perfCounter = Perf.open(event, fd, cpu, options);
            return perfCounter;
        }
        finally {
            Perf.close(fd);
        }
    }

    private static PerfCounter openGlobal(PerfEvent event, int pid, PerfOption ... options) throws IOException {
        String optionString = Perf.optionString(options);
        int[] fds = new int[REAL_CPU_COUNT];
        try {
            for (int cpu = 0; cpu < fds.length; ++cpu) {
                fds[cpu] = Perf.openEvent(pid, cpu, event.type, event.config, event.breakpoint, -1, optionString);
            }
        }
        catch (Throwable e) {
            for (int fd : fds) {
                if (fd <= 0) continue;
                Perf.close(fd);
            }
            throw e;
        }
        return new PerfCounterGlobal(event, fds);
    }

    private static String optionString(PerfOption ... options) {
        StringBuilder sb = new StringBuilder();
        for (PerfOption option : options) {
            sb.append(option).append(',');
        }
        return sb.toString();
    }

    private static boolean hasOption(PerfOption[] options, PerfOption option) {
        for (PerfOption o : options) {
            if (o != option) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getRealCpuCount() {
        try (FileInputStream in = new FileInputStream("/sys/devices/system/cpu/present");){
            byte[] buf = new byte[1024];
            int bytes = in.read(buf);
            if (bytes <= 0) return Runtime.getRuntime().availableProcessors();
            String s = new String(buf, 0, bytes, StandardCharsets.ISO_8859_1).trim();
            int idx = Math.max(s.lastIndexOf(45), s.lastIndexOf(44));
            int n = Integer.parseInt(s.substring(idx + 1)) + 1;
            return n;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Runtime.getRuntime().availableProcessors();
    }

    static native int openEvent(int var0, int var1, int var2, long var3, int var5, int var6, String var7) throws IOException;

    static native int openFile(String var0) throws IOException;

    static native void close(int var0);

    static native long get(int var0) throws IOException;

    static native void ioctl(int var0, int var1, int var2);
}

