/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.util.ServiceConfigurationError;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import one.nio.mgt.Management;
import one.nio.net.SslConfig;
import one.nio.net.SslContext;
import one.nio.net.SslContextMXBean;
import one.nio.util.ByteArrayBuilder;
import one.nio.util.Utf8;

class NativeSslContext
extends SslContext {
    private static final AtomicInteger counter = new AtomicInteger();
    final int id = counter.incrementAndGet();
    long ctx = NativeSslContext.ctxNew();
    NativeSslContext[] subcontexts;

    NativeSslContext() throws SSLException {
        Management.registerMXBean(new NativeSslContextMXBeanImpl(), "one.nio.net:type=SslContext,id=" + this.id);
    }

    @Override
    public void close() {
        if (this.ctx != 0L) {
            this.setSubcontexts(null);
            Management.unregisterMXBean("one.nio.net:type=SslContext,id=" + this.id);
            NativeSslContext.ctxFree(this.ctx);
            this.ctx = 0L;
        }
    }

    private void setSubcontexts(NativeSslContext[] newSubcontexts) {
        if (this.subcontexts != null) {
            for (NativeSslContext subcontext : this.subcontexts) {
                subcontext.close();
            }
        }
        this.subcontexts = newSubcontexts;
    }

    private NativeSslContext[] createSubcontexts(SslConfig[] sni) throws IOException {
        NativeSslContext[] subcontexts = new NativeSslContext[sni.length];
        try {
            for (int i = 0; i < sni.length; ++i) {
                if (sni[i].hostName == null) {
                    throw new SSLException("SNI config requires hostName");
                }
                subcontexts[i] = new NativeSslContext();
                subcontexts[i].configure(sni[i]);
            }
        }
        catch (IOException e) {
            for (int i = 0; i < sni.length && subcontexts[i] != null; ++i) {
                subcontexts[i].close();
            }
            throw e;
        }
        return subcontexts;
    }

    @Override
    public native void setDebug(boolean var1);

    @Override
    public native boolean getDebug();

    @Override
    public void setProtocols(String protocols) {
        int enabled = 0;
        StringTokenizer st = new StringTokenizer(protocols.toLowerCase(), " ,:+", false);
        while (st.hasMoreTokens()) {
            String protocol;
            switch (protocol = st.nextToken()) {
                case "compression": {
                    enabled |= 0x20000;
                    break;
                }
                case "sslv2": {
                    enabled |= 0x1000000;
                    break;
                }
                case "sslv3": {
                    enabled |= 0x2000000;
                    break;
                }
                case "tlsv1": {
                    enabled |= 0x4000000;
                    break;
                }
                case "tlsv1.1": {
                    enabled |= 0x10000000;
                    break;
                }
                case "tlsv1.2": {
                    enabled |= 0x8000000;
                    break;
                }
                case "tlsv1.3": {
                    enabled |= 0x20000000;
                }
            }
        }
        int all = 1057095680;
        this.clearOptions(enabled);
        this.setOptions(all - enabled);
    }

    @Override
    public native void setCiphers(String var1) throws SSLException;

    @Override
    public native void setCertificate(String var1) throws SSLException;

    @Override
    public native void setPrivateKey(String var1) throws SSLException;

    @Override
    public native void setPassphrase(byte[] var1) throws SSLException;

    @Override
    public native void setCA(String var1) throws SSLException;

    @Override
    public native void setVerify(int var1) throws SSLException;

    @Override
    public native void setTicketKeys(byte[] var1) throws SSLException;

    @Override
    public native void setCacheSize(int var1) throws SSLException;

    @Override
    public native void setTimeout(long var1) throws SSLException;

    @Override
    public native void setSessionId(byte[] var1) throws SSLException;

    @Override
    public native void setOCSP(byte[] var1) throws SSLException;

    @Override
    public void setApplicationProtocols(String[] protocols) throws SSLException {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        for (String protocol : protocols) {
            byte len = (byte)Utf8.length(protocol);
            builder.append(len).append(protocol);
        }
        this.setApplicationProtocols0(builder.toBytes());
    }

    private native void setApplicationProtocols0(byte[] var1) throws SSLException;

    @Override
    public void setSNI(SslConfig[] sni) throws IOException {
        if (sni == null || sni.length == 0) {
            this.setSubcontexts(null);
            this.setSNI0(null, null);
            return;
        }
        NativeSslContext[] subcontexts = this.createSubcontexts(sni);
        this.setSubcontexts(subcontexts);
        ByteArrayBuilder names = new ByteArrayBuilder();
        long[] contexts = new long[subcontexts.length];
        for (int i = 0; i < subcontexts.length; ++i) {
            names.append(sni[i].hostName).append((byte)0);
            contexts[i] = subcontexts[i].ctx;
        }
        names.append((byte)0);
        this.setSNI0(names.toBytes(), contexts);
    }

    private native void setSNI0(byte[] var1, long[] var2) throws SSLException;

    private native void setOptions(int var1);

    private native void clearOptions(int var1);

    private native long getSessionCounter(int var1);

    private native long[] getSessionCounters(int var1);

    private static native void init();

    private static native long ctxNew() throws SSLException;

    private static native void ctxFree(long var0);

    static {
        NativeSslContext.init();
    }

    private class NativeSslContextMXBeanImpl
    implements SslContextMXBean {
        private NativeSslContextMXBeanImpl() {
        }

        @Override
        public void setDebug(boolean debug) {
            NativeSslContext.this.setDebug(debug);
        }

        @Override
        public boolean getDebug() {
            return NativeSslContext.this.getDebug();
        }

        @Override
        public long getNumber() {
            return NativeSslContext.this.getSessionCounter(0);
        }

        @Override
        public long getConnect() {
            return NativeSslContext.this.getSessionCounter(1);
        }

        @Override
        public long getConnectGood() {
            return NativeSslContext.this.getSessionCounter(2);
        }

        @Override
        public long getConnectRenegotiate() {
            return NativeSslContext.this.getSessionCounter(3);
        }

        @Override
        public long getAccept() {
            return NativeSslContext.this.getSessionCounter(4);
        }

        @Override
        public long getAcceptGood() {
            return NativeSslContext.this.getSessionCounter(5);
        }

        @Override
        public long getAcceptRenegotiate() {
            return NativeSslContext.this.getSessionCounter(6);
        }

        @Override
        public long getHits() {
            return NativeSslContext.this.getSessionCounter(7);
        }

        @Override
        public long getCustomHits() {
            return NativeSslContext.this.getSessionCounter(8);
        }

        @Override
        public long getMisses() {
            return NativeSslContext.this.getSessionCounter(9);
        }

        @Override
        public long getTimeouts() {
            return NativeSslContext.this.getSessionCounter(10);
        }

        @Override
        public long getEvicted() {
            return NativeSslContext.this.getSessionCounter(11);
        }
    }

    static class Holder {
        static final NativeSslContext DEFAULT;

        Holder() {
        }

        static {
            try {
                DEFAULT = new NativeSslContext();
                DEFAULT.configure(SslConfig.from(System.getProperties()));
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Could not create OpenSSL context", e);
            }
        }
    }
}

