/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import one.nio.net.JavaSocket;
import one.nio.net.SelectableJavaSocket;
import one.nio.net.Socket;
import one.nio.net.SslContext;
import one.nio.net.SslOption;

final class JavaServerSocket
extends SelectableJavaSocket {
    final ServerSocketChannel ch = ServerSocketChannel.open();

    JavaServerSocket() throws IOException {
    }

    @Override
    public final boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public final void close() {
        try {
            this.ch.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final JavaSocket accept() throws IOException {
        return new JavaSocket(this.ch.accept());
    }

    @Override
    public final void connect(InetAddress address, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void bind(InetAddress address, int port, int backlog) throws IOException {
        this.ch.bind(new InetSocketAddress(address, port), backlog);
    }

    @Override
    public final void listen(int backlog) throws IOException {
    }

    @Override
    public final int writeRaw(long buf, int count, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int write(byte[] data, int offset, int count, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void writeFully(byte[] data, int offset, int count) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int send(ByteBuffer data, int flags, InetAddress address, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int readRaw(long buf, int count, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int read(byte[] data, int offset, int count, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final InetSocketAddress recv(ByteBuffer buffer, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void readFully(byte[] data, int offset, int count) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long sendFile(RandomAccessFile file, long offset, long count) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setBlocking(boolean blocking) {
        try {
            this.ch.configureBlocking(blocking);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isBlocking() {
        return this.ch.isBlocking();
    }

    @Override
    public final void setTimeout(int timeout) {
        try {
            this.ch.socket().setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int getTimeout() {
        try {
            return this.ch.socket().getSoTimeout();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public final void setKeepAlive(boolean keepAlive) {
    }

    @Override
    public boolean getKeepAlive() {
        return false;
    }

    @Override
    public final void setNoDelay(boolean noDelay) {
    }

    @Override
    public boolean getNoDelay() {
        return false;
    }

    @Override
    public final void setTcpFastOpen(boolean tcpFastOpen) {
    }

    @Override
    public boolean getTcpFastOpen() {
        return false;
    }

    @Override
    public final void setDeferAccept(boolean deferAccept) {
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    @Override
    public final void setReuseAddr(boolean reuseAddr, boolean reusePort) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean getReuseAddr() {
        try {
            return this.ch.getOption(StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean getReusePort() {
        return false;
    }

    @Override
    public final void setRecvBuffer(int recvBuf) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)recvBuf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getRecvBuffer() {
        try {
            return this.ch.getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public final void setTos(int tos) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)tos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getTos() {
        try {
            return this.ch.getOption(StandardSocketOptions.IP_TOS);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public final void setSendBuffer(int sendBuf) {
    }

    @Override
    public int getSendBuffer() {
        return 0;
    }

    @Override
    public final byte[] getOption(int level, int option) {
        return null;
    }

    @Override
    public final boolean setOption(int level, int option, byte[] value) {
        return false;
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        try {
            return (InetSocketAddress)this.ch.getLocalAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket sslWrap(SslContext context) {
        return this;
    }

    @Override
    public Socket sslUnwrap() {
        return this;
    }

    @Override
    public SslContext getSslContext() {
        return null;
    }

    @Override
    public <T> T getSslOption(SslOption<T> option) {
        return null;
    }

    @Override
    public SelectableChannel getSelectableChannel() {
        return this.ch;
    }
}

