/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import one.nio.async.AsyncExecutor;
import one.nio.async.ParallelTask;
import one.nio.lock.RWLock;
import one.nio.mem.DirectMemory;
import one.nio.mem.OffheapMapMXBean;
import one.nio.mem.OutOfMemoryException;
import one.nio.os.BatchThread;
import one.nio.util.JavaInternals;
import one.nio.util.QuickSelect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.Unsafe;

public abstract class OffheapMap<K, V>
implements OffheapMapMXBean {
    protected static final Log log = LogFactory.getLog(OffheapMap.class);
    protected static final Unsafe unsafe = JavaInternals.unsafe;
    protected static final long byteArrayOffset = JavaInternals.byteArrayOffset;
    protected static final long MB = 0x100000L;
    protected static final int CONCURRENCY_LEVEL = 65536;
    protected static final int HASH_OFFSET = 0;
    protected static final int NEXT_OFFSET = 8;
    protected static final int TIME_OFFSET = 16;
    protected static final int HEADER_SIZE = 24;
    protected final int capacity;
    protected final AtomicInteger count = new AtomicInteger();
    protected final AtomicLong expirations = new AtomicLong();
    protected final RWLock[] locks = OffheapMap.createLocks();
    protected long mapBase;
    protected long timeToLive = Long.MAX_VALUE;
    protected long minTimeToLive = 0L;
    protected long lockWaitTime = 10L;
    protected long cleanupInterval = 60000L;
    protected double cleanupThreshold = 0.1;
    protected int maxSamples = 1000;
    protected BasicCleanup cleanupThread;

    protected OffheapMap(int capacity) {
        this.capacity = capacity + 65535 & 0xFFFF0000;
    }

    protected OffheapMap(int capacity, long address) {
        this(capacity);
        this.mapBase = address != 0L ? address : DirectMemory.allocateAndClear((long)this.capacity * 8L, this);
    }

    private static RWLock[] createLocks() {
        RWLock[] locks = new RWLock[65536];
        for (int i = 0; i < 65536; ++i) {
            locks[i] = new RWLock();
        }
        return locks;
    }

    public final void close() {
        if (this.cleanupThread != null) {
            try {
                this.cleanupThread.interrupt();
                this.cleanupThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.closeInternal();
    }

    protected void closeInternal() {
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public long getMinTimeToLive() {
        return this.minTimeToLive;
    }

    @Override
    public void setMinTimeToLive(long minTimeToLive) {
        this.minTimeToLive = minTimeToLive;
    }

    @Override
    public long getLockWaitTime() {
        return this.lockWaitTime;
    }

    @Override
    public void setLockWaitTime(long lockWaitTime) {
        this.lockWaitTime = lockWaitTime;
    }

    @Override
    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    @Override
    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    @Override
    public double getCleanupThreshold() {
        return this.cleanupThreshold;
    }

    @Override
    public void setCleanupThreshold(double cleanupThreshold) {
        this.cleanupThreshold = cleanupThreshold;
    }

    @Override
    public int getMaxSamples() {
        return this.maxSamples;
    }

    @Override
    public void setMaxSamples(int maxSamples) {
        this.maxSamples = maxSamples;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getCount() {
        return this.count.get();
    }

    @Override
    public long getExpirations() {
        return this.expirations.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        long hashCode = this.hashCode(key);
        long currentPtr = this.bucketFor(hashCode);
        RWLock lock = this.lockFor(hashCode).lockRead();
        try {
            long entry;
            while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
                if (unsafe.getLong(entry + 0L) == hashCode && this.equalsAt(entry, key)) {
                    V v = this.isExpired(entry, true) ? null : (V)this.valueAt(entry);
                    return v;
                }
                currentPtr = entry + 8L;
            }
        }
        finally {
            lock.unlockRead();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(K key, V value) throws OutOfMemoryException {
        long hashCode = this.hashCode(key);
        long currentPtr = this.bucketFor(hashCode);
        int newSize = this.sizeOf(value);
        boolean newEntry = true;
        RWLock lock = this.lockFor(hashCode).lockWrite();
        try {
            long entry;
            while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
                if (unsafe.getLong(entry + 0L) == hashCode && this.equalsAt(entry, key)) {
                    int oldSize = this.sizeOf(entry);
                    if (newSize <= oldSize) {
                        this.setTimeAt(entry);
                        this.setValueAt(entry, value);
                        boolean bl = false;
                        return bl;
                    }
                    unsafe.putAddress(currentPtr, unsafe.getAddress(entry + 8L));
                    this.destroyEntry(entry);
                    this.count.decrementAndGet();
                    newEntry = false;
                    break;
                }
                currentPtr = entry + 8L;
            }
            entry = this.allocateEntry(key, hashCode, newSize);
            unsafe.putLong(entry + 0L, hashCode);
            unsafe.putAddress(entry + 8L, unsafe.getAddress(currentPtr));
            this.setTimeAt(entry);
            this.setValueAt(entry, value);
            unsafe.putAddress(currentPtr, entry);
        }
        finally {
            lock.unlockWrite();
        }
        this.count.incrementAndGet();
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfAbsent(K key, V value) throws OutOfMemoryException {
        long hashCode = this.hashCode(key);
        long currentPtr = this.bucketFor(hashCode);
        int newSize = this.sizeOf(value);
        RWLock lock = this.lockFor(hashCode).lockWrite();
        try {
            long entry;
            while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
                if (unsafe.getLong(entry + 0L) == hashCode && this.equalsAt(entry, key)) {
                    if (this.isExpired(entry, false)) {
                        unsafe.putAddress(currentPtr, unsafe.getAddress(entry + 8L));
                        this.destroyEntry(entry);
                        this.count.decrementAndGet();
                        break;
                    }
                    boolean bl = false;
                    return bl;
                }
                currentPtr = entry + 8L;
            }
            entry = this.allocateEntry(key, hashCode, newSize);
            unsafe.putLong(entry + 0L, hashCode);
            unsafe.putAddress(entry + 8L, 0L);
            this.setTimeAt(entry);
            this.setValueAt(entry, value);
            unsafe.putAddress(currentPtr, entry);
        }
        finally {
            lock.unlockWrite();
        }
        this.count.incrementAndGet();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        long entry;
        long hashCode = this.hashCode(key);
        long currentPtr = this.bucketFor(hashCode);
        RWLock lock = this.lockFor(hashCode).lockWrite();
        try {
            while (true) {
                if ((entry = unsafe.getAddress(currentPtr)) == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (unsafe.getLong(entry + 0L) == hashCode && this.equalsAt(entry, key)) {
                    unsafe.putAddress(currentPtr, unsafe.getAddress(entry + 8L));
                    break;
                }
                currentPtr = entry + 8L;
            }
        }
        finally {
            lock.unlockWrite();
        }
        boolean expired = this.isExpired(entry, false);
        this.destroyEntry(entry);
        this.count.decrementAndGet();
        return !expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(K key) {
        long hashCode = this.hashCode(key);
        long currentPtr = this.bucketFor(hashCode);
        RWLock lock = this.lockFor(hashCode).lockRead();
        try {
            long entry;
            while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
                if (unsafe.getLong(entry + 0L) == hashCode && this.equalsAt(entry, key)) {
                    this.setTimeAt(entry);
                    return;
                }
                currentPtr = entry + 8L;
            }
        }
        finally {
            lock.unlockRead();
        }
    }

    public Record<K, V> lockRecordForRead(K key, long timeout) throws TimeoutException {
        long hashCode = this.hashCode(key);
        RWLock lock = this.lockFor(hashCode);
        if (!lock.lockRead(timeout)) {
            throw new TimeoutException();
        }
        return this.createRecord(key, hashCode, lock);
    }

    public Record<K, V> lockRecordForRead(K key) {
        long hashCode = this.hashCode(key);
        RWLock lock = this.lockFor(hashCode).lockRead();
        return this.createRecord(key, hashCode, lock);
    }

    private Record<K, V> createRecord(K key, long hashCode, RWLock lock) {
        long entry;
        long currentPtr = this.bucketFor(hashCode);
        while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
            if (unsafe.getLong(entry + 0L) == hashCode && this.equalsAt(entry, key)) {
                if (this.isExpired(entry, true)) break;
                return new Record(this, lock, entry);
            }
            currentPtr = entry + 8L;
        }
        lock.unlockRead();
        return null;
    }

    public WritableRecord<K, V> lockRecordForWrite(K key, long timeout, boolean create) throws TimeoutException {
        long hashCode = this.hashCode(key);
        RWLock lock = this.lockFor(hashCode);
        if (!lock.lockWrite(timeout)) {
            throw new TimeoutException();
        }
        return this.createWritableRecord(key, hashCode, lock, create);
    }

    public WritableRecord<K, V> lockRecordForWrite(K key, boolean create) {
        long hashCode = this.hashCode(key);
        RWLock lock = this.lockFor(hashCode).lockWrite();
        return this.createWritableRecord(key, hashCode, lock, create);
    }

    private WritableRecord<K, V> createWritableRecord(K key, long hashCode, RWLock lock, boolean create) {
        long entry;
        long currentPtr = this.bucketFor(hashCode);
        while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
            if (unsafe.getLong(entry + 0L) == hashCode && this.equalsAt(entry, key)) {
                return new WritableRecord(this, lock, entry, key, currentPtr);
            }
            currentPtr = entry + 8L;
        }
        if (create) {
            return new WritableRecord(this, lock, 0L, key, currentPtr);
        }
        lock.unlockWrite();
        return null;
    }

    public int entriesToClean() {
        return this.getCount() - (int)((double)this.getCapacity() * (1.0 - this.cleanupThreshold));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeExpired(long expirationAge) {
        int expired = 0;
        long expirationTime = System.currentTimeMillis() - expirationAge;
        for (int i = 0; i < 65536; ++i) {
            RWLock lock = this.locks[i];
            if (!lock.lockWrite(this.lockWaitTime)) {
                log.debug((Object)("Could not lock segment " + i + " for cleanup"));
                continue;
            }
            try {
                for (int j = i; j < this.capacity; j += 65536) {
                    long currentPtr = this.mapBase + (long)j * 8L;
                    long entry = unsafe.getAddress(currentPtr);
                    while (entry != 0L) {
                        long nextEntry = unsafe.getAddress(entry + 8L);
                        if (this.shouldCleanup(entry, expirationTime)) {
                            unsafe.putAddress(currentPtr, nextEntry);
                            this.destroyEntry(entry);
                            ++expired;
                        } else {
                            currentPtr = entry + 8L;
                        }
                        entry = nextEntry;
                    }
                }
                continue;
            }
            finally {
                lock.unlockWrite();
            }
        }
        this.count.addAndGet(-expired);
        this.expirations.addAndGet(expired);
        return expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int cleared = 0;
        for (int i = 0; i < 65536; ++i) {
            RWLock lock = this.locks[i].lockWrite();
            try {
                for (int j = i; j < this.capacity; j += 65536) {
                    long currentPtr = this.mapBase + (long)j * 8L;
                    long entry = unsafe.getAddress(currentPtr);
                    while (entry != 0L) {
                        long nextEntry = unsafe.getAddress(entry + 8L);
                        this.destroyEntry(entry);
                        ++cleared;
                        entry = nextEntry;
                    }
                    unsafe.putAddress(currentPtr, 0L);
                }
                continue;
            }
            finally {
                lock.unlockWrite();
            }
        }
        this.count.addAndGet(-cleared);
    }

    public void iterate(Visitor<K, V> visitor) {
        this.iterate(visitor, 0, 1);
    }

    public void iterate(final Visitor<K, V> visitor, int workers) {
        AsyncExecutor.fork(workers, new ParallelTask(){

            @Override
            public void execute(int taskNum, int taskCount) {
                OffheapMap.this.iterate(visitor, taskNum, taskCount);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(Visitor<K, V> visitor, int taskNum, int taskCount) {
        for (int i = taskNum; i < this.capacity; i += taskCount) {
            long currentPtr = this.mapBase + (long)i * 8L;
            RWLock lock = this.locks[i & 0xFFFF].lockRead();
            try {
                long entry;
                while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
                    visitor.visit(new Record(this, lock, entry));
                    currentPtr = entry + 8L;
                }
                continue;
            }
            finally {
                lock.unlockRead();
            }
        }
    }

    public void iterate(WritableVisitor<K, V> visitor) {
        this.iterate(visitor, 0, 1);
    }

    public void iterate(final WritableVisitor<K, V> visitor, int workers) {
        AsyncExecutor.fork(workers, new ParallelTask(){

            @Override
            public void execute(int taskNum, int taskCount) {
                OffheapMap.this.iterate(visitor, taskNum, taskCount);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(WritableVisitor<K, V> visitor, int taskNum, int taskCount) {
        for (int i = taskNum; i < this.capacity; i += taskCount) {
            long currentPtr = this.mapBase + (long)i * 8L;
            RWLock lock = this.locks[i & 0xFFFF].lockWrite();
            try {
                long entry;
                while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
                    WritableRecord record = new WritableRecord(this, lock, entry, this.keyAt(entry), currentPtr);
                    visitor.visit(record);
                    if (record.entry == 0L) continue;
                    currentPtr = record.entry + 8L;
                }
                continue;
            }
            finally {
                lock.unlockWrite();
            }
        }
    }

    protected long bucketFor(long hashCode) {
        return this.mapBase + (hashCode & Long.MAX_VALUE) % (long)this.capacity * 8L;
    }

    protected RWLock lockFor(long hashCode) {
        return this.locks[(int)hashCode & 0xFFFF];
    }

    protected long timeAt(long entry) {
        return unsafe.getLong(entry + 16L);
    }

    protected void setTimeAt(long entry) {
        unsafe.putLong(entry + 16L, System.currentTimeMillis());
    }

    protected void setTimeAt(long entry, long time) {
        unsafe.putLong(entry + 16L, time);
    }

    protected boolean isExpired(long entry, boolean touch) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - unsafe.getLong(entry + 16L) > this.timeToLive) {
            return true;
        }
        if (touch) {
            unsafe.putLong(entry + 16L, currentTime);
        }
        return false;
    }

    protected boolean shouldCleanup(long entry, long expirationTime) {
        return this.timeAt(entry) <= expirationTime;
    }

    protected K keyAt(long entry) {
        return null;
    }

    protected abstract long hashCode(K var1);

    protected abstract boolean equalsAt(long var1, K var3);

    protected abstract V valueAt(long var1);

    protected abstract void setValueAt(long var1, V var3);

    protected abstract long allocateEntry(K var1, long var2, int var4) throws OutOfMemoryException;

    protected abstract void destroyEntry(long var1);

    protected abstract int sizeOf(long var1);

    protected abstract int sizeOf(V var1);

    public class SamplingCleanup
    extends BasicCleanup {
        public SamplingCleanup(String name) {
            super(name);
        }

        @Override
        protected int cleanup() {
            int entriesToClean = OffheapMap.this.entriesToClean();
            if (entriesToClean <= 0) {
                return 0;
            }
            long[] timestamps = new long[OffheapMap.this.getMaxSamples()];
            int samples = this.collectSamples(timestamps);
            if (samples == 0) {
                return 0;
            }
            int count = OffheapMap.this.getCount();
            int k = entriesToClean < count ? (int)((long)samples * (long)entriesToClean / (long)count) : 0;
            long expirationAge = System.currentTimeMillis() - QuickSelect.select(timestamps, k, 0, samples - 1);
            log.info((Object)(this.getName() + " needs to clean " + entriesToClean + " entries. Samples collected = " + samples + ", age = " + expirationAge));
            if (log.isDebugEnabled()) {
                log.debug((Object)Arrays.toString(timestamps));
            }
            return OffheapMap.this.removeExpired(Math.max(expirationAge, OffheapMap.this.getMinTimeToLive()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int collectSamples(long[] timestamps) {
            int startBucket;
            int samples = 0;
            int bucket = startBucket = ThreadLocalRandom.current().nextInt(65536);
            do {
                RWLock lock = OffheapMap.this.locks[bucket].lockRead();
                try {
                    for (int i = bucket; i < OffheapMap.this.capacity; i += 65536) {
                        long entry;
                        long currentPtr = OffheapMap.this.mapBase + (long)i * 8L;
                        while ((entry = unsafe.getAddress(currentPtr)) != 0L) {
                            timestamps[samples++] = OffheapMap.this.timeAt(entry);
                            if (samples == timestamps.length) {
                                int n = samples;
                                return n;
                            }
                            currentPtr = entry + 8L;
                        }
                    }
                }
                finally {
                    lock.unlockRead();
                }
            } while ((bucket = bucket + 1 & 0xFFFF) != startBucket);
            return samples;
        }
    }

    public class BasicCleanup
    extends BatchThread {
        protected final Object waitLock;

        public BasicCleanup(String name) {
            super(name);
            this.waitLock = new Object();
            OffheapMap.this.cleanupThread = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BasicCleanup.adjustPriority();
            while (!this.isInterrupted()) {
                try {
                    Object object = this.waitLock;
                    synchronized (object) {
                        this.waitLock.wait(OffheapMap.this.getCleanupInterval());
                    }
                    long startTime = System.currentTimeMillis();
                    int expired = this.cleanup();
                    long elapsed = System.currentTimeMillis() - startTime;
                    if (expired == 0) continue;
                    log.info((Object)(this.getName() + " cleaned " + expired + " entries in " + elapsed + " ms"));
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Throwable e) {
                    log.error((Object)("Exception in " + this.getName()), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void force() {
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }

        protected int cleanup() {
            return OffheapMap.this.removeExpired(OffheapMap.this.timeToLive);
        }
    }

    public static interface WritableVisitor<K, V> {
        public void visit(WritableRecord<K, V> var1);
    }

    public static interface Visitor<K, V> {
        public void visit(Record<K, V> var1);
    }

    public static class WritableRecord<K, V>
    extends Record<K, V> {
        protected K key;
        protected long currentPtr;

        protected WritableRecord(OffheapMap<K, V> map, RWLock lock, long entry, K key, long currentPtr) {
            super(map, lock, entry);
            this.key = key;
            this.currentPtr = currentPtr;
        }

        public void setValue(V value) throws OutOfMemoryException {
            int newSize = this.map.sizeOf(value);
            if (this.entry != 0L) {
                int oldSize = this.map.sizeOf(this.entry);
                if (newSize <= oldSize) {
                    this.map.setTimeAt(this.entry);
                    this.map.setValueAt(this.entry, value);
                    return;
                }
                unsafe.putAddress(this.currentPtr, unsafe.getAddress(this.entry + 8L));
                this.map.destroyEntry(this.entry);
                this.map.count.decrementAndGet();
            }
            long hash = this.map.hashCode(this.key);
            this.entry = this.map.allocateEntry(this.key, hash, newSize);
            unsafe.putLong(this.entry + 0L, hash);
            unsafe.putAddress(this.entry + 8L, unsafe.getAddress(this.currentPtr));
            this.map.setTimeAt(this.entry);
            this.map.setValueAt(this.entry, value);
            unsafe.putAddress(this.currentPtr, this.entry);
            this.map.count.incrementAndGet();
        }

        public void remove() {
            unsafe.putAddress(this.currentPtr, unsafe.getAddress(this.entry + 8L));
            this.map.destroyEntry(this.entry);
            this.map.count.decrementAndGet();
            this.entry = 0L;
        }

        public boolean isNullOrExpired() {
            return this.entry == 0L || this.map.isExpired(this.entry, false);
        }

        public long currentPtr() {
            return this.currentPtr;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public void release() {
            this.lock.unlockWrite();
        }
    }

    public static class Record<K, V> {
        protected final OffheapMap<K, V> map;
        protected final RWLock lock;
        protected long entry;

        protected Record(OffheapMap<K, V> map, RWLock lock, long entry) {
            this.map = map;
            this.lock = lock;
            this.entry = entry;
        }

        public OffheapMap<K, V> map() {
            return this.map;
        }

        public RWLock lock() {
            return this.lock;
        }

        public long entry() {
            return this.entry;
        }

        public long hash() {
            return unsafe.getLong(this.entry + 0L);
        }

        public K key() {
            return this.map.keyAt(this.entry);
        }

        public V value() {
            return this.map.valueAt(this.entry);
        }

        public long time() {
            return this.map.timeAt(this.entry);
        }

        public void touch() {
            this.map.setTimeAt(this.entry);
        }

        public int size() {
            return this.map.sizeOf(this.entry);
        }

        public void release() {
            this.lock.unlockRead();
        }
    }
}

