/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import one.nio.mem.DirectMemory;
import one.nio.os.Mem;
import one.nio.serial.DataStream;
import one.nio.util.JavaInternals;

public class MappedFile
implements Closeable {
    private static final Method force0 = JavaInternals.getMethod(MappedByteBuffer.class, "force0", FileDescriptor.class, Long.TYPE, Long.TYPE);
    private static final int STATE_CLOSED = 0;
    private static final int STATE_MALLOC = 1;
    private static final int STATE_MMAP = 2;
    public static final int MAP_RO = 0;
    public static final int MAP_RW = 1;
    public static final int MAP_PV = 2;
    private final RandomAccessFile file;
    private final long addr;
    private final long size;
    private int mode;
    private int state;

    public MappedFile(long size) {
        this.file = null;
        this.addr = DirectMemory.allocateRaw(size);
        this.size = size;
        this.mode = 1;
        this.state = 1;
    }

    public MappedFile(String name, long size) throws IOException {
        this(name, size, 1);
    }

    public MappedFile(String name, long size, int mode) throws IOException {
        this.file = new RandomAccessFile(name, mode == 1 ? "rw" : "r");
        try {
            if (size == 0L) {
                size = this.file.length();
            } else if (mode == 1) {
                this.file.setLength(size);
            }
            this.addr = MappedFile.map(this.file, mode, 0L, size);
            this.size = size;
            this.mode = mode;
            this.state = 2;
        }
        catch (IOException e) {
            this.file.close();
            throw e;
        }
    }

    public void sync() throws IOException {
        if (this.state != 2 || this.mode != 1) {
            return;
        }
        if (Mem.IS_SUPPORTED) {
            int err = Mem.msync(this.addr, this.size, 4);
            if (err != 0) {
                throw new IOException("msync failed: " + err);
            }
        } else {
            try {
                force0.invoke((Object)DirectMemory.prototype, this.file.getFD(), this.addr, this.size);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                throw target instanceof IOException ? (IOException)target : new IOException(target);
            }
        }
    }

    public void makeReadonly() throws IOException {
        int err;
        if (this.state != 2 || this.mode != 1) {
            throw new IllegalStateException();
        }
        if (Mem.IS_SUPPORTED && (err = Mem.mprotect(this.addr, this.size, 1)) != 0) {
            throw new IOException("mprotect failed: " + err);
        }
        this.mode = 0;
    }

    @Override
    public void close() {
        if (this.state == 1) {
            DirectMemory.freeRaw(this.addr);
        } else if (this.state == 2) {
            MappedFile.unmap(this.addr, this.size);
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.state = 0;
    }

    public final RandomAccessFile getFile() {
        return this.file;
    }

    public final long getAddr() {
        return this.addr;
    }

    public final long getSize() {
        return this.size;
    }

    public int getMode() {
        return this.mode;
    }

    public DataStream dataStream(ByteOrder order) {
        if (ByteOrder.nativeOrder().equals(order)) {
            throw new UnsupportedOperationException("Native byte order is not implemeneted");
        }
        return new DataStream(this.addr, this.size);
    }

    public static long map(RandomAccessFile f, int mode, long start, long size) throws IOException {
        int flags;
        int prot;
        long result;
        if (Mem.IS_SUPPORTED && (result = Mem.mmap(0L, size, prot = mode == 0 ? 1 : 3, flags = mode == 2 ? 2 : 1, f.getFD(), start)) != -1L) {
            return result;
        }
        try {
            Method map0 = Class.forName("sun.nio.ch.FileChannelImpl").getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
            map0.setAccessible(true);
            return (Long)map0.invoke((Object)f.getChannel(), mode, start, size);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            throw target instanceof IOException ? (IOException)target : new IOException(target);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void unmap(long start, long size) {
        if (Mem.IS_SUPPORTED && Mem.munmap(start, size) == 0) {
            return;
        }
        try {
            Method unmap0 = Class.forName("sun.nio.ch.FileChannelImpl").getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            unmap0.setAccessible(true);
            unmap0.invoke(null, start, size);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

