/*
 * Decompiled with CFR 0.152.
 */
package one.nio.config;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import one.nio.config.Config;
import one.nio.config.Converter;
import one.nio.util.JavaInternals;

public class ConfigParser {
    private final StringTokenizer st;
    private final Map<String, Object> references;
    private String line;
    private int indent;

    private ConfigParser(String config) {
        this.st = new StringTokenizer(config, "\r\n");
        this.references = new HashMap<String, Object>();
        this.indent = -1;
    }

    public static <T> T parse(String config, Class<T> type) {
        return ConfigParser.parse(config, type);
    }

    public static <T> T parse(String config, Type type) {
        ConfigParser parser = new ConfigParser(config);
        if (parser.nextLine() < 0) {
            throw new IllegalArgumentException("Unexpected end of input");
        }
        try {
            return (T)parser.parseValue(type, 0);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Object parseValue(Type type, int level) throws ReflectiveOperationException {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (this.isScalar(cls)) {
                return this.parseScalar(cls, this.tail());
            }
            if (cls.isArray()) {
                Object ref = this.parseReference();
                return ref != null ? ref : this.parseArray(cls.getComponentType(), level);
            }
            if (cls.isAnnotationPresent(Config.class)) {
                Object ref = this.parseReference();
                return ref != null ? ref : this.parseBean(cls, level);
            }
            Method method = JavaInternals.findMethod(cls, "valueOf", String.class);
            if (method != null && (method.getModifiers() & 8) != 0 && cls.isAssignableFrom(method.getReturnType())) {
                return method.invoke(null, this.tail());
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class rawType = (Class)ptype.getRawType();
            if (Collection.class.isAssignableFrom(rawType) && ptype.getActualTypeArguments().length >= 1) {
                Object ref = this.parseReference();
                return ref != null ? ref : this.parseCollection((Collection)((Object)rawType), ptype.getActualTypeArguments()[0], level);
            }
            if (Map.class.isAssignableFrom(rawType) && ptype.getActualTypeArguments().length >= 2) {
                Object ref = this.parseReference();
                Type[] mapArgs = ptype.getActualTypeArguments();
                return ref != null ? ref : this.parseMap((Map)((Object)rawType), mapArgs[0], mapArgs[1], level);
            }
        } else if (type instanceof GenericArrayType) {
            Object ref = this.parseReference();
            return ref != null ? ref : this.parseArray(((GenericArrayType)type).getGenericComponentType(), level);
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    private Object parseBean(Class<?> type, int minLevel) throws ReflectiveOperationException {
        Object obj = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.registerReference(obj);
        this.fillBean(obj, minLevel);
        return obj;
    }

    private void fillBean(Object obj, int minLevel) throws ReflectiveOperationException {
        Map<String, Field> fields = ConfigParser.collectFields(obj.getClass());
        int level = this.nextLine();
        if (level >= minLevel) {
            do {
                int colon;
                if ((colon = this.line.indexOf(58, level)) < 0) {
                    throw new IllegalArgumentException("Field expected: " + this.line);
                }
                String key = this.line.substring(level, colon).trim();
                Field f = fields.get(key);
                if (f == null) {
                    throw new IllegalArgumentException("Unknown field: " + this.line);
                }
                this.skipSpaces(colon + 1);
                Converter converter = f.getAnnotation(Converter.class);
                Object value = converter != null ? this.convert(this.tail(), converter) : this.parseValue(f.getGenericType(), level + 1);
                f.set(obj, value);
            } while (this.isSameLevel(this.nextLine(), level, minLevel));
        }
    }

    private Object convert(String value, Converter converter) throws ReflectiveOperationException {
        Class<?> cls = converter.value();
        Method method = JavaInternals.findMethodRecursively(cls, converter.method(), String.class);
        if (method == null) {
            throw new IllegalArgumentException("Invalid converter class: " + cls.getName());
        }
        Object sender = (method.getModifiers() & 8) != 0 ? null : cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return method.invoke(sender, value);
    }

    private Object parseArray(Type elementType, int minLevel) throws ReflectiveOperationException {
        List list = this.parseCollection(new ArrayList(), elementType, minLevel);
        Class<?> cls = this.resolveArrayElementType(elementType);
        Object array = Array.newInstance(cls, list.size());
        this.changeReference(list, array);
        if (cls.isPrimitive()) {
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
        return list.toArray((Object[])array);
    }

    private Class<?> resolveArrayElementType(Type elementType) {
        if (elementType instanceof Class) {
            return (Class)elementType;
        }
        if (elementType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)elementType).getRawType();
        }
        throw new IllegalArgumentException("Invalid array element type: " + elementType);
    }

    private void changeReference(List<?> list, Object array) {
        for (Map.Entry<String, Object> ref : this.references.entrySet()) {
            if (ref.getValue() != list) continue;
            ref.setValue(array);
            return;
        }
    }

    private Collection<Object> parseCollection(Class<?> rawType, Type elementType, int minLevel) throws ReflectiveOperationException {
        if (rawType == List.class || rawType == Collection.class) {
            return this.parseCollection(new ArrayList(), elementType, minLevel);
        }
        if (rawType == Set.class) {
            return this.parseCollection(new HashSet(), elementType, minLevel);
        }
        return this.parseCollection((Collection)rawType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), elementType, minLevel);
    }

    private <T extends Collection<Object>> T parseCollection(T list, Type elementType, int minLevel) throws ReflectiveOperationException {
        this.registerReference(list);
        if (this.hasTail()) {
            Class cls;
            if (elementType instanceof Class && this.isScalar(cls = (Class)elementType)) {
                String tail = this.tail();
                if (tail.charAt(0) == '[' && tail.charAt(tail.length() - 1) == ']') {
                    tail = tail.substring(1, tail.length() - 1);
                }
                for (String element : tail.split(",")) {
                    list.add((Object)this.parseScalar(cls, element.trim()));
                }
                return list;
            }
            throw new IllegalArgumentException("Array is expected");
        }
        int level = this.nextLine();
        if (level >= minLevel - 1 && this.line.charAt(level) == '-') {
            do {
                this.skipSpaces(level + 1);
                Object value = this.parseValue(elementType, level + 1);
                list.add((Object)value);
            } while (this.nextLine() == level && this.line.charAt(level) == '-');
        }
        return list;
    }

    private Map<Object, Object> parseMap(Class<?> rawType, Type keyType, Type valueType, int minLevel) throws ReflectiveOperationException {
        if (rawType == Map.class) {
            return this.parseMap(new HashMap(), keyType, valueType, minLevel);
        }
        return this.parseMap((Map)rawType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), keyType, valueType, minLevel);
    }

    private <T extends Map<Object, Object>> T parseMap(T map, Type keyType, Type valueType, int minLevel) throws ReflectiveOperationException {
        this.registerReference(map);
        Class keyClass = keyType instanceof Class && this.isScalar((Class)keyType) ? (Class)keyType : String.class;
        int level = this.nextLine();
        if (level >= minLevel) {
            do {
                int colon;
                if ((colon = this.line.indexOf(58, level)) < 0) {
                    throw new IllegalArgumentException("Key expected: " + this.line);
                }
                Object key = this.parseScalar(keyClass, this.line.substring(level, colon).trim());
                this.skipSpaces(colon + 1);
                Object value = this.parseValue(valueType, level + 1);
                map.put((Object)key, (Object)value);
            } while (this.isSameLevel(this.nextLine(), level, minLevel));
        }
        return map;
    }

    private boolean isSameLevel(int newLevel, int prevLevel, int minLevel) {
        if (newLevel == prevLevel) {
            return true;
        }
        if (newLevel < minLevel) {
            return false;
        }
        throw new IllegalArgumentException("Level differs: " + newLevel + " != " + prevLevel + " at " + this.line);
    }

    private boolean isScalar(Class<?> type) {
        return type.isPrimitive() || type == String.class || type == Boolean.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Character.class || type.isEnum();
    }

    private Object parseScalar(Class<?> type, String value) {
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return "true".equalsIgnoreCase(value);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.decode(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.decode(value);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.decode(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.decode(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        return null;
    }

    private void registerReference(Object ref) {
        if (this.hasTail() && this.line.charAt(this.indent) == '&') {
            Object prev = this.references.put(this.line.substring(this.indent + 1).trim(), ref);
            if (prev != null) {
                throw new IllegalArgumentException("Duplicate reference: " + this.line);
            }
            this.indent = -1;
        }
    }

    private Object parseReference() {
        if (this.hasTail() && this.line.charAt(this.indent) == '*') {
            Object ref = this.references.get(this.line.substring(this.indent + 1).trim());
            if (ref == null) {
                throw new IllegalArgumentException("No such reference: " + this.line);
            }
            this.indent = -1;
            return ref;
        }
        return null;
    }

    private static Map<String, Field> collectFields(Class<?> cls) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        while (cls != Object.class) {
            for (Field f : cls.getDeclaredFields()) {
                if ((f.getModifiers() & 0x1088) != 0) continue;
                f.setAccessible(true);
                map.put(f.getName(), f);
            }
            cls = cls.getSuperclass();
        }
        return map;
    }

    private int nextLine() {
        if (this.indent >= 0) {
            return this.indent;
        }
        block0: while (this.st.hasMoreTokens()) {
            String s = this.st.nextToken();
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t') continue;
                if (c == '#') continue block0;
                this.line = s;
                this.indent = i;
                return this.indent;
            }
        }
        this.indent = -1;
        return -1;
    }

    private void skipSpaces(int from) {
        int length = this.line.length();
        for (int i = from; i < length; ++i) {
            char c = this.line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            if (c == '#') break;
            this.indent = i;
            return;
        }
        this.indent = -1;
    }

    private String tail() {
        String result = this.indent >= 0 ? this.line.substring(this.indent).trim() : "";
        this.indent = -1;
        return result;
    }

    private boolean hasTail() {
        return this.indent >= 0 && this.indent < this.line.length();
    }
}

