/*
 * Decompiled with CFR 0.152.
 */
package one.nio.async;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CombinedFuture<V>
implements Future<List<V>>,
Serializable {
    private Future<V>[] futures;

    public CombinedFuture(Future<V> ... futures) {
        this.futures = futures;
    }

    public CombinedFuture(Collection<Future> futures) {
        this.futures = futures.toArray(new Future[0]);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = true;
        for (Future<V> future : this.futures) {
            result &= future.cancel(mayInterruptIfRunning);
        }
        return result;
    }

    @Override
    public boolean isCancelled() {
        boolean result = true;
        for (Future<V> future : this.futures) {
            result &= future.isCancelled();
        }
        return result;
    }

    @Override
    public boolean isDone() {
        boolean result = true;
        for (Future<V> future : this.futures) {
            result &= future.isDone();
        }
        return result;
    }

    @Override
    public List<V> get() throws InterruptedException, ExecutionException {
        ArrayList<V> result = new ArrayList<V>(this.futures.length);
        for (Future<V> future : this.futures) {
            result.add(future.get());
        }
        return result;
    }

    @Override
    public List<V> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<V> result = new ArrayList<V>(this.futures.length);
        for (Future<V> future : this.futures) {
            result.add(future.get(timeout, unit));
        }
        return result;
    }
}

