/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import redis.embedded.AbstractRedisInstance;
import redis.embedded.RedisRunScriptEnum;
import redis.embedded.RedisServerBuilder;
import redis.embedded.util.JarUtil;

public class RedisServer
extends AbstractRedisInstance {
    private static final String REDIS_READY_PATTERN = ".*The server is now ready to accept connections on port.*";
    private static final int DEFAULT_REDIS_PORT = 6379;

    public RedisServer() throws IOException {
        this((Integer)6379);
    }

    public RedisServer(Integer port) throws IOException {
        super(port);
        File executable = JarUtil.extractExecutableFromJar(RedisRunScriptEnum.getRedisRunScript());
        this.args = Arrays.asList(executable.getAbsolutePath(), "--port", Integer.toString(port));
    }

    public RedisServer(File executable, Integer port) {
        super(port);
        this.args = Arrays.asList(executable.getAbsolutePath(), "--port", Integer.toString(port));
    }

    RedisServer(List<String> args, int port) {
        super(port);
        this.args = new ArrayList<String>(args);
    }

    public static RedisServerBuilder builder() {
        return new RedisServerBuilder();
    }

    @Override
    protected String redisReadyPattern() {
        return REDIS_READY_PATTERN;
    }
}

