/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import redis.embedded.Redis;
import redis.embedded.exceptions.EmbeddedRedisException;

abstract class AbstractRedisInstance
implements Redis {
    protected List<String> args = Collections.emptyList();
    private volatile boolean active = false;
    private Process redisProcess;
    private final int port;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    protected AbstractRedisInstance(int port) {
        this.port = port;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized void start() throws EmbeddedRedisException {
        if (this.active) {
            throw new EmbeddedRedisException("This redis server instance is already running...");
        }
        try {
            this.redisProcess = this.createRedisProcessBuilder().start();
            this.logErrors();
            this.awaitRedisServerReady();
            this.active = true;
        }
        catch (IOException e) {
            throw new EmbeddedRedisException("Failed to start Redis instance", e);
        }
    }

    private void logErrors() {
        InputStream errorStream = this.redisProcess.getErrorStream();
        this.executor.submit(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void awaitRedisServerReady() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.redisProcess.getInputStream()));){
            String outputLine;
            do {
                if ((outputLine = reader.readLine()) != null) continue;
                throw new RuntimeException("Can't start redis server. Check logs for details.");
            } while (!outputLine.matches(this.redisReadyPattern()));
        }
    }

    protected abstract String redisReadyPattern();

    private ProcessBuilder createRedisProcessBuilder() {
        File executable = new File(this.args.get(0));
        ProcessBuilder pb = new ProcessBuilder(this.args);
        pb.directory(executable.getParentFile());
        return pb;
    }

    @Override
    public synchronized void stop() throws EmbeddedRedisException {
        if (this.active) {
            this.redisProcess.destroy();
            this.tryWaitFor();
            this.active = false;
        }
    }

    private void tryWaitFor() {
        try {
            this.redisProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new EmbeddedRedisException("Failed to stop redis instance", e);
        }
    }

    @Override
    public List<Integer> ports() {
        return Arrays.asList(this.port);
    }
}

