/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public class RedisServer {
    private static final String REDIS_READY_PATTERN = ".*The server is now ready to accept connections on port.*";
    private final File command;
    private final Integer port;
    private volatile boolean active = false;
    private Process redisProcess;

    public RedisServer(File command, Integer port) {
        this.command = command;
        this.port = port;
    }

    public RedisServer(Integer port) throws IOException {
        this.port = port;
        this.command = this.extractExecutableFromJar(RedisRunScriptEnum.getRedisRunScript());
    }

    private File extractExecutableFromJar(String scriptName) throws IOException {
        File tmpDir = Files.createTempDir();
        tmpDir.deleteOnExit();
        File command = new File(tmpDir, scriptName);
        FileUtils.copyURLToFile((URL)Resources.getResource((String)scriptName), (File)command);
        command.deleteOnExit();
        command.setExecutable(true);
        return command;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void start() throws IOException {
        if (this.active) {
            throw new RuntimeException("This redis server instance is already running...");
        }
        this.redisProcess = this.createRedisProcessBuilder().start();
        this.awaitRedisServerReady();
        this.active = true;
    }

    private void awaitRedisServerReady() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.redisProcess.getInputStream()));
        try {
            String outputLine = null;
            while ((outputLine = reader.readLine()) != null && !outputLine.matches(REDIS_READY_PATTERN)) {
            }
        }
        finally {
            reader.close();
        }
    }

    private ProcessBuilder createRedisProcessBuilder() {
        ProcessBuilder pb = new ProcessBuilder(this.command.getAbsolutePath(), "--port", Integer.toString(this.port));
        pb.directory(this.command.getParentFile());
        pb.redirectErrorStream();
        return pb;
    }

    public synchronized void stop() throws InterruptedException {
        if (this.active) {
            this.redisProcess.destroy();
            this.redisProcess.waitFor();
            this.active = false;
        }
    }

    private static enum RedisRunScriptEnum {
        WINDOWS_32("redis-server.exe"),
        WINDOWS_64("redis-server-64.exe"),
        UNIX("redis-server"),
        MACOSX("redis-server.app");

        private final String runScript;

        private RedisRunScriptEnum(String runScript) {
            this.runScript = runScript;
        }

        public static String getRedisRunScript() {
            String osName = System.getProperty("os.name").toLowerCase();
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (osName.contains("win")) {
                if (osArch.contains("64")) {
                    return RedisRunScriptEnum.WINDOWS_64.runScript;
                }
                return RedisRunScriptEnum.WINDOWS_32.runScript;
            }
            if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
                return RedisRunScriptEnum.UNIX.runScript;
            }
            if ("Mac OS X".equalsIgnoreCase(osName)) {
                return RedisRunScriptEnum.MACOSX.runScript;
            }
            throw new RuntimeException("Unsupported os/architecture...: " + osName + " on " + osArch);
        }
    }
}

