/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.merge;

import java.io.IOException;
import shadow.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import shadow.org.eclipse.jgit.errors.MissingObjectException;
import shadow.org.eclipse.jgit.lib.AnyObjectId;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectInserter;
import shadow.org.eclipse.jgit.lib.Repository;
import shadow.org.eclipse.jgit.merge.Merger;
import shadow.org.eclipse.jgit.revwalk.RevCommit;
import shadow.org.eclipse.jgit.revwalk.RevTree;
import shadow.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import shadow.org.eclipse.jgit.treewalk.EmptyTreeIterator;

public abstract class ThreeWayMerger
extends Merger {
    private RevTree baseTree;
    private ObjectId baseCommitId;

    protected ThreeWayMerger(Repository local) {
        super(local);
    }

    protected ThreeWayMerger(Repository local, boolean inCore) {
        this(local);
    }

    protected ThreeWayMerger(ObjectInserter inserter) {
        super(inserter);
    }

    public void setBase(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.baseTree = id != null ? this.walk.parseTree(id) : null;
    }

    @Override
    public boolean merge(AnyObjectId ... tips) throws IOException {
        if (tips.length != 2) {
            return false;
        }
        return super.merge(tips);
    }

    @Override
    public ObjectId getBaseCommitId() {
        return this.baseCommitId;
    }

    protected AbstractTreeIterator mergeBase() throws IOException {
        RevCommit baseCommit;
        if (this.baseTree != null) {
            return this.openTree(this.baseTree);
        }
        RevCommit revCommit = baseCommit = this.baseCommitId != null ? this.walk.parseCommit(this.baseCommitId) : this.getBaseCommit(this.sourceCommits[0], this.sourceCommits[1]);
        if (baseCommit == null) {
            this.baseCommitId = null;
            return new EmptyTreeIterator();
        }
        this.baseCommitId = baseCommit.toObjectId();
        return this.openTree(baseCommit.getTree());
    }
}

