/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.internal.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import shadow.org.eclipse.jgit.errors.ObjectWritingException;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import shadow.org.eclipse.jgit.internal.storage.file.ObjectDirectoryPackParser;
import shadow.org.eclipse.jgit.internal.storage.file.WindowCursor;
import shadow.org.eclipse.jgit.internal.storage.file.WriteConfig;
import shadow.org.eclipse.jgit.lib.Config;
import shadow.org.eclipse.jgit.lib.Constants;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectInserter;
import shadow.org.eclipse.jgit.lib.ObjectReader;
import shadow.org.eclipse.jgit.transport.PackParser;
import shadow.org.eclipse.jgit.util.FileUtils;
import shadow.org.eclipse.jgit.util.IO;
import shadow.org.eclipse.jgit.util.sha1.SHA1;

class ObjectDirectoryInserter
extends ObjectInserter {
    private final FileObjectDatabase db;
    private final WriteConfig config;
    private Deflater deflate;

    ObjectDirectoryInserter(FileObjectDatabase dest, Config cfg) {
        this.db = dest;
        this.config = cfg.get(WriteConfig.KEY);
    }

    @Override
    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        return this.insert(type, data, off, len, false);
    }

    private ObjectId insert(int type, byte[] data, int off, int len, boolean createDuplicate) throws IOException {
        ObjectId id = this.idFor(type, data, off, len);
        if (!createDuplicate && this.db.has(id)) {
            return id;
        }
        File tmp = this.toTemp(type, data, off, len);
        return this.insertOneObject(tmp, id, createDuplicate);
    }

    @Override
    public ObjectId insert(int type, long len, InputStream is) throws IOException {
        return this.insert(type, len, is, false);
    }

    ObjectId insert(int type, long len, InputStream is, boolean createDuplicate) throws IOException {
        if (len <= (long)this.buffer().length) {
            byte[] buf = this.buffer();
            int actLen = IO.readFully(is, buf, 0);
            return this.insert(type, buf, 0, actLen, createDuplicate);
        }
        SHA1 md = this.digest();
        File tmp = this.toTemp(md, type, len, is);
        ObjectId id = md.toObjectId();
        return this.insertOneObject(tmp, id, createDuplicate);
    }

    private ObjectId insertOneObject(File tmp, ObjectId id, boolean createDuplicate) throws IOException {
        switch (this.db.insertUnpackedObject(tmp, id, createDuplicate)) {
            case INSERTED: 
            case EXISTS_PACKED: 
            case EXISTS_LOOSE: {
                return id;
            }
        }
        File dst = this.db.fileFor(id);
        throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToCreateNewObject, dst));
    }

    @Override
    public PackParser newPackParser(InputStream in) throws IOException {
        return new ObjectDirectoryPackParser(this.db, in);
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this.db, this);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        if (this.deflate != null) {
            try {
                this.deflate.end();
            }
            finally {
                this.deflate = null;
            }
        }
    }

    private File toTemp(SHA1 md, int type, long len, InputStream is) throws IOException {
        boolean delete = true;
        File tmp = this.newTempFile();
        try {
            File file;
            block22: {
                Throwable throwable = null;
                Object var9_9 = null;
                FileOutputStream fOut = new FileOutputStream(tmp);
                try {
                    try {
                        OutputStream out = fOut;
                        if (this.config.getFSyncObjectFiles()) {
                            out = Channels.newOutputStream(fOut.getChannel());
                        }
                        DeflaterOutputStream cOut = this.compress(out);
                        SHA1OutputStream dOut = new SHA1OutputStream(cOut, md);
                        this.writeHeader(dOut, type, len);
                        byte[] buf = this.buffer();
                        while (len > 0L) {
                            int n = is.read(buf, 0, (int)Math.min(len, (long)buf.length));
                            if (n <= 0) {
                                throw ObjectDirectoryInserter.shortInput(len);
                            }
                            dOut.write(buf, 0, n);
                            len -= (long)n;
                        }
                        dOut.flush();
                        cOut.finish();
                    }
                    finally {
                        if (this.config.getFSyncObjectFiles()) {
                            fOut.getChannel().force(true);
                        }
                    }
                    delete = false;
                    file = tmp;
                    if (fOut == null) break block22;
                }
                catch (Throwable throwable2) {
                    try {
                        if (fOut != null) {
                            fOut.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                fOut.close();
            }
            return file;
        }
        finally {
            if (delete) {
                FileUtils.delete(tmp, 2);
            }
        }
    }

    private File toTemp(int type, byte[] buf, int pos, int len) throws IOException {
        boolean delete = true;
        File tmp = this.newTempFile();
        try {
            File file;
            block20: {
                Throwable throwable = null;
                Object var8_9 = null;
                FileOutputStream fOut = new FileOutputStream(tmp);
                try {
                    try {
                        OutputStream out = fOut;
                        if (this.config.getFSyncObjectFiles()) {
                            out = Channels.newOutputStream(fOut.getChannel());
                        }
                        DeflaterOutputStream cOut = this.compress(out);
                        this.writeHeader(cOut, type, len);
                        cOut.write(buf, pos, len);
                        cOut.finish();
                    }
                    finally {
                        if (this.config.getFSyncObjectFiles()) {
                            fOut.getChannel().force(true);
                        }
                    }
                    delete = false;
                    file = tmp;
                    if (fOut == null) break block20;
                }
                catch (Throwable throwable2) {
                    try {
                        if (fOut != null) {
                            fOut.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                fOut.close();
            }
            return file;
        }
        finally {
            if (delete) {
                FileUtils.delete(tmp, 2);
            }
        }
    }

    void writeHeader(OutputStream out, int type, long len) throws IOException {
        out.write(Constants.encodedTypeString(type));
        out.write(32);
        out.write(Constants.encodeASCII(len));
        out.write(0);
    }

    File newTempFile() throws IOException {
        return File.createTempFile("noz", null, this.db.getDirectory());
    }

    DeflaterOutputStream compress(OutputStream out) {
        if (this.deflate == null) {
            this.deflate = new Deflater(this.config.getCompression());
        } else {
            this.deflate.reset();
        }
        return new DeflaterOutputStream(out, this.deflate, 8192);
    }

    private static EOFException shortInput(long missing) {
        return new EOFException(MessageFormat.format(JGitText.get().inputDidntMatchLength, missing));
    }

    private static class SHA1OutputStream
    extends FilterOutputStream {
        private final SHA1 md;

        SHA1OutputStream(OutputStream out, SHA1 md) {
            super(out);
            this.md = md;
        }

        @Override
        public void write(int b) throws IOException {
            this.md.update((byte)b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] in, int p, int n) throws IOException {
            this.md.update(in, p, n);
            this.out.write(in, p, n);
        }
    }
}

