/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.internal.storage.file;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.NoSuchElementException;
import shadow.com.googlecode.javaewah.EWAHCompressedBitmap;
import shadow.com.googlecode.javaewah.IntIterator;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.internal.storage.file.BitSet;
import shadow.org.eclipse.jgit.internal.storage.file.InflatingBitSet;
import shadow.org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import shadow.org.eclipse.jgit.lib.AnyObjectId;
import shadow.org.eclipse.jgit.lib.BitmapIndex;
import shadow.org.eclipse.jgit.lib.BitmapObject;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import shadow.org.eclipse.jgit.util.BlockList;

public class BitmapIndexImpl
implements BitmapIndex {
    private static final int EXTRA_BITS = 10240;
    final PackBitmapIndex packIndex;
    final MutableBitmapIndex mutableIndex;
    final int indexObjectCount;

    public BitmapIndexImpl(PackBitmapIndex packIndex) {
        this.packIndex = packIndex;
        this.mutableIndex = new MutableBitmapIndex();
        this.indexObjectCount = packIndex.getObjectCount();
    }

    PackBitmapIndex getPackBitmapIndex() {
        return this.packIndex;
    }

    @Override
    public CompressedBitmap getBitmap(AnyObjectId objectId) {
        EWAHCompressedBitmap compressed = this.packIndex.getBitmap(objectId);
        if (compressed == null) {
            return null;
        }
        return new CompressedBitmap(compressed, this);
    }

    @Override
    public CompressedBitmapBuilder newBitmapBuilder() {
        return new CompressedBitmapBuilder(this);
    }

    int findPosition(AnyObjectId objectId) {
        int position = this.packIndex.findPosition(objectId);
        if (position < 0 && (position = this.mutableIndex.findPosition(objectId)) >= 0) {
            position += this.indexObjectCount;
        }
        return position;
    }

    int findOrInsert(AnyObjectId objectId, int type) {
        int position = this.findPosition(objectId);
        if (position < 0) {
            position = this.mutableIndex.findOrInsert(objectId, type);
            position += this.indexObjectCount;
        }
        return position;
    }

    static final EWAHCompressedBitmap ones(int sizeInBits) {
        EWAHCompressedBitmap mask = new EWAHCompressedBitmap();
        mask.addStreamOfEmptyWords(true, sizeInBits / 64);
        int remaining = sizeInBits % 64;
        if (remaining > 0) {
            mask.addWord((1L << remaining) - 1L, remaining);
        }
        return mask;
    }

    private static final class BitmapObjectImpl
    extends BitmapObject {
        private ObjectId objectId;
        private int type;

        private BitmapObjectImpl() {
        }

        @Override
        public ObjectId getObjectId() {
            return this.objectId;
        }

        @Override
        public int getType() {
            return this.type;
        }
    }

    private static final class ComboBitset {
        private InflatingBitSet inflatingBitmap;
        private BitSet toAdd;
        private BitSet toRemove;

        ComboBitset() {
            this(new EWAHCompressedBitmap());
        }

        ComboBitset(EWAHCompressedBitmap bitmap) {
            this.inflatingBitmap = new InflatingBitSet(bitmap);
        }

        EWAHCompressedBitmap combine() {
            EWAHCompressedBitmap toAddCompressed = null;
            if (this.toAdd != null) {
                toAddCompressed = this.toAdd.toEWAHCompressedBitmap();
                this.toAdd = null;
            }
            EWAHCompressedBitmap toRemoveCompressed = null;
            if (this.toRemove != null) {
                toRemoveCompressed = this.toRemove.toEWAHCompressedBitmap();
                this.toRemove = null;
            }
            if (toAddCompressed != null) {
                this.or(toAddCompressed);
            }
            if (toRemoveCompressed != null) {
                this.andNot(toRemoveCompressed);
            }
            return this.inflatingBitmap.getBitmap();
        }

        void or(EWAHCompressedBitmap inbits) {
            if (this.toRemove != null) {
                this.combine();
            }
            this.inflatingBitmap = this.inflatingBitmap.or(inbits);
        }

        void andNot(EWAHCompressedBitmap inbits) {
            if (this.toAdd != null || this.toRemove != null) {
                this.combine();
            }
            this.inflatingBitmap = this.inflatingBitmap.andNot(inbits);
        }

        void xor(EWAHCompressedBitmap inbits) {
            if (this.toAdd != null || this.toRemove != null) {
                this.combine();
            }
            this.inflatingBitmap = this.inflatingBitmap.xor(inbits);
        }

        boolean contains(int position) {
            if (this.toRemove != null && this.toRemove.get(position)) {
                return false;
            }
            if (this.toAdd != null && this.toAdd.get(position)) {
                return true;
            }
            return this.inflatingBitmap.contains(position);
        }

        void remove(int position) {
            if (this.toAdd != null) {
                this.toAdd.clear(position);
            }
            if (this.inflatingBitmap.maybeContains(position)) {
                if (this.toRemove == null) {
                    this.toRemove = new BitSet(position + 10240);
                }
                this.toRemove.set(position);
            }
        }

        void set(int position) {
            if (this.toRemove != null) {
                this.toRemove.clear(position);
            }
            if (this.toAdd == null) {
                this.toAdd = new BitSet(position + 10240);
            }
            this.toAdd.set(position);
        }
    }

    public static final class CompressedBitmap
    implements BitmapIndex.Bitmap {
        final EWAHCompressedBitmap bitmap;
        final BitmapIndexImpl bitmapIndex;

        public CompressedBitmap(EWAHCompressedBitmap bitmap, BitmapIndexImpl bitmapIndex) {
            this.bitmap = bitmap;
            this.bitmapIndex = bitmapIndex;
        }

        @Override
        public CompressedBitmap or(BitmapIndex.Bitmap other) {
            return new CompressedBitmap(this.bitmap.or(this.ewahBitmap(other)), this.bitmapIndex);
        }

        @Override
        public CompressedBitmap andNot(BitmapIndex.Bitmap other) {
            return new CompressedBitmap(this.bitmap.andNot(this.ewahBitmap(other)), this.bitmapIndex);
        }

        @Override
        public CompressedBitmap xor(BitmapIndex.Bitmap other) {
            return new CompressedBitmap(this.bitmap.xor(this.ewahBitmap(other)), this.bitmapIndex);
        }

        private final IntIterator ofObjectType(int type) {
            return this.bitmapIndex.packIndex.ofObjectType(this.bitmap, type).intIterator();
        }

        @Override
        public Iterator<BitmapObject> iterator() {
            IntIterator dynamic = this.bitmap.andNot(BitmapIndexImpl.ones(this.bitmapIndex.indexObjectCount)).intIterator();
            final IntIterator commits = this.ofObjectType(1);
            final IntIterator trees = this.ofObjectType(2);
            final IntIterator blobs = this.ofObjectType(3);
            final IntIterator tags = this.ofObjectType(4);
            return new Iterator<BitmapObject>(dynamic){
                private final BitmapObjectImpl out = new BitmapObjectImpl();
                private int type;
                private IntIterator cached;
                {
                    this.cached = intIterator;
                }

                @Override
                public boolean hasNext() {
                    if (!this.cached.hasNext()) {
                        if (commits.hasNext()) {
                            this.type = 1;
                            this.cached = commits;
                        } else if (trees.hasNext()) {
                            this.type = 2;
                            this.cached = trees;
                        } else if (blobs.hasNext()) {
                            this.type = 3;
                            this.cached = blobs;
                        } else if (tags.hasNext()) {
                            this.type = 4;
                            this.cached = tags;
                        } else {
                            return false;
                        }
                    }
                    return true;
                }

                @Override
                public BitmapObject next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int position = this.cached.next();
                    if (position < bitmapIndex.indexObjectCount) {
                        this.out.type = this.type;
                        this.out.objectId = bitmapIndex.packIndex.getObject(position);
                    } else {
                        MutableEntry entry = bitmapIndex.mutableIndex.getObject(position -= bitmapIndex.indexObjectCount);
                        this.out.type = entry.type;
                        this.out.objectId = entry;
                    }
                    return this.out;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public EWAHCompressedBitmap retrieveCompressed() {
            return this.bitmap;
        }

        private EWAHCompressedBitmap ewahBitmap(BitmapIndex.Bitmap other) {
            if (other instanceof CompressedBitmap) {
                CompressedBitmap b = (CompressedBitmap)other;
                if (b.bitmapIndex != this.bitmapIndex) {
                    throw new IllegalArgumentException();
                }
                return b.bitmap;
            }
            if (other instanceof CompressedBitmapBuilder) {
                CompressedBitmapBuilder b = (CompressedBitmapBuilder)other;
                if (b.bitmapIndex != this.bitmapIndex) {
                    throw new IllegalArgumentException();
                }
                return b.bitset.combine();
            }
            throw new IllegalArgumentException();
        }
    }

    private static final class CompressedBitmapBuilder
    implements BitmapIndex.BitmapBuilder {
        private ComboBitset bitset = new ComboBitset();
        private final BitmapIndexImpl bitmapIndex;

        CompressedBitmapBuilder(BitmapIndexImpl bitmapIndex) {
            this.bitmapIndex = bitmapIndex;
        }

        @Override
        public boolean contains(AnyObjectId objectId) {
            int position = this.bitmapIndex.findPosition(objectId);
            return position >= 0 && this.bitset.contains(position);
        }

        @Override
        public BitmapIndex.BitmapBuilder addObject(AnyObjectId objectId, int type) {
            this.bitset.set(this.bitmapIndex.findOrInsert(objectId, type));
            return this;
        }

        @Override
        public void remove(AnyObjectId objectId) {
            int position = this.bitmapIndex.findPosition(objectId);
            if (position >= 0) {
                this.bitset.remove(position);
            }
        }

        @Override
        public CompressedBitmapBuilder or(BitmapIndex.Bitmap other) {
            this.bitset.or(this.ewahBitmap(other));
            return this;
        }

        @Override
        public CompressedBitmapBuilder andNot(BitmapIndex.Bitmap other) {
            this.bitset.andNot(this.ewahBitmap(other));
            return this;
        }

        @Override
        public CompressedBitmapBuilder xor(BitmapIndex.Bitmap other) {
            this.bitset.xor(this.ewahBitmap(other));
            return this;
        }

        @Override
        public CompressedBitmap build() {
            return new CompressedBitmap(this.bitset.combine(), this.bitmapIndex);
        }

        @Override
        public Iterator<BitmapObject> iterator() {
            return this.build().iterator();
        }

        @Override
        public int cardinality() {
            return this.bitset.combine().cardinality();
        }

        @Override
        public boolean removeAllOrNone(PackBitmapIndex index) {
            if (!this.bitmapIndex.packIndex.equals(index)) {
                return false;
            }
            EWAHCompressedBitmap curr = this.bitset.combine().xor(BitmapIndexImpl.ones(this.bitmapIndex.indexObjectCount));
            IntIterator ii = curr.intIterator();
            if (ii.hasNext() && ii.next() < this.bitmapIndex.indexObjectCount) {
                return false;
            }
            this.bitset = new ComboBitset(curr);
            return true;
        }

        @Override
        public BitmapIndexImpl getBitmapIndex() {
            return this.bitmapIndex;
        }

        @Override
        public EWAHCompressedBitmap retrieveCompressed() {
            return this.build().retrieveCompressed();
        }

        private EWAHCompressedBitmap ewahBitmap(BitmapIndex.Bitmap other) {
            if (other instanceof CompressedBitmap) {
                CompressedBitmap b = (CompressedBitmap)other;
                if (b.bitmapIndex != this.bitmapIndex) {
                    throw new IllegalArgumentException();
                }
                return b.bitmap;
            }
            if (other instanceof CompressedBitmapBuilder) {
                CompressedBitmapBuilder b = (CompressedBitmapBuilder)other;
                if (b.bitmapIndex != this.bitmapIndex) {
                    throw new IllegalArgumentException();
                }
                return b.bitset.combine();
            }
            throw new IllegalArgumentException();
        }
    }

    private static final class MutableBitmapIndex {
        private final ObjectIdOwnerMap<MutableEntry> revMap = new ObjectIdOwnerMap();
        private final BlockList<MutableEntry> revList = new BlockList();

        private MutableBitmapIndex() {
        }

        int findPosition(AnyObjectId objectId) {
            MutableEntry entry = this.revMap.get(objectId);
            if (entry == null) {
                return -1;
            }
            return entry.position;
        }

        MutableEntry getObject(int position) {
            try {
                MutableEntry entry = this.revList.get(position);
                if (entry == null) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().objectNotFound, String.valueOf(position)));
                }
                return entry;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        int findOrInsert(AnyObjectId objectId, int type) {
            MutableEntry entry = new MutableEntry(objectId, type, this.revList.size());
            this.revList.add(entry);
            this.revMap.add(entry);
            return entry.position;
        }
    }

    private static final class MutableEntry
    extends ObjectIdOwnerMap.Entry {
        final int type;
        final int position;

        MutableEntry(AnyObjectId objectId, int type, int position) {
            super(objectId);
            this.type = type;
            this.position = position;
        }
    }
}

