/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.api;

import java.io.IOException;
import shadow.org.eclipse.jgit.api.GitCommand;
import shadow.org.eclipse.jgit.api.errors.GitAPIException;
import shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import shadow.org.eclipse.jgit.lib.Ref;
import shadow.org.eclipse.jgit.lib.Repository;
import shadow.org.eclipse.jgit.notes.Note;
import shadow.org.eclipse.jgit.notes.NoteMap;
import shadow.org.eclipse.jgit.revwalk.RevCommit;
import shadow.org.eclipse.jgit.revwalk.RevObject;
import shadow.org.eclipse.jgit.revwalk.RevWalk;

public class ShowNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected ShowNoteCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk walk = new RevWalk(this.repo);){
                Ref ref = this.repo.exactRef(this.notesRef);
                if (ref != null) {
                    notesCommit = walk.parseCommit(ref.getObjectId());
                    map = NoteMap.read(walk.getObjectReader(), notesCommit);
                }
                return map.getNote(this.id);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public ShowNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public ShowNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

