/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.api;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import shadow.org.eclipse.jgit.api.GitCommand;
import shadow.org.eclipse.jgit.api.errors.GitAPIException;
import shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import shadow.org.eclipse.jgit.api.errors.NoHeadException;
import shadow.org.eclipse.jgit.diff.DiffEntry;
import shadow.org.eclipse.jgit.diff.DiffFormatter;
import shadow.org.eclipse.jgit.dircache.DirCacheIterator;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.lib.NullProgressMonitor;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectReader;
import shadow.org.eclipse.jgit.lib.ProgressMonitor;
import shadow.org.eclipse.jgit.lib.Repository;
import shadow.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import shadow.org.eclipse.jgit.treewalk.CanonicalTreeParser;
import shadow.org.eclipse.jgit.treewalk.FileTreeIterator;
import shadow.org.eclipse.jgit.treewalk.filter.TreeFilter;
import shadow.org.eclipse.jgit.util.io.NullOutputStream;

public class DiffCommand
extends GitCommand<List<DiffEntry>> {
    private AbstractTreeIterator oldTree;
    private AbstractTreeIterator newTree;
    private boolean cached;
    private TreeFilter pathFilter = TreeFilter.ALL;
    private boolean showNameAndStatusOnly;
    private OutputStream out;
    private int contextLines = -1;
    private String sourcePrefix;
    private String destinationPrefix;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected DiffCommand(Repository repo) {
        super(repo);
    }

    private DiffFormatter getDiffFormatter() {
        return this.out != null && !this.showNameAndStatusOnly ? new DiffFormatter(new BufferedOutputStream(this.out)) : new DiffFormatter(NullOutputStream.INSTANCE);
    }

    @Override
    public List<DiffEntry> call() throws GitAPIException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DiffFormatter diffFmt = this.getDiffFormatter();){
                diffFmt.setRepository(this.repo);
                diffFmt.setProgressMonitor(this.monitor);
                if (this.cached) {
                    if (this.oldTree == null) {
                        ObjectId head = this.repo.resolve("HEAD^{tree}");
                        if (head == null) {
                            throw new NoHeadException(JGitText.get().cannotReadTree);
                        }
                        CanonicalTreeParser p = new CanonicalTreeParser();
                        Throwable throwable2 = null;
                        Object var7_11 = null;
                        try (ObjectReader reader = this.repo.newObjectReader();){
                            p.reset(reader, head);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        this.oldTree = p;
                    }
                    this.newTree = new DirCacheIterator(this.repo.readDirCache());
                } else {
                    if (this.oldTree == null) {
                        this.oldTree = new DirCacheIterator(this.repo.readDirCache());
                    }
                    if (this.newTree == null) {
                        this.newTree = new FileTreeIterator(this.repo);
                    }
                }
                diffFmt.setPathFilter(this.pathFilter);
                List<DiffEntry> result = diffFmt.scan(this.oldTree, this.newTree);
                if (this.showNameAndStatusOnly) {
                    return result;
                }
                if (this.contextLines >= 0) {
                    diffFmt.setContext(this.contextLines);
                }
                if (this.destinationPrefix != null) {
                    diffFmt.setNewPrefix(this.destinationPrefix);
                }
                if (this.sourcePrefix != null) {
                    diffFmt.setOldPrefix(this.sourcePrefix);
                }
                diffFmt.format(result);
                diffFmt.flush();
                return result;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public DiffCommand setCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public DiffCommand setPathFilter(TreeFilter pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public DiffCommand setOldTree(AbstractTreeIterator oldTree) {
        this.oldTree = oldTree;
        return this;
    }

    public DiffCommand setNewTree(AbstractTreeIterator newTree) {
        this.newTree = newTree;
        return this;
    }

    public DiffCommand setShowNameAndStatusOnly(boolean showNameAndStatusOnly) {
        this.showNameAndStatusOnly = showNameAndStatusOnly;
        return this;
    }

    public DiffCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public DiffCommand setContextLines(int contextLines) {
        this.contextLines = contextLines;
        return this;
    }

    public DiffCommand setSourcePrefix(String sourcePrefix) {
        this.sourcePrefix = sourcePrefix;
        return this;
    }

    public DiffCommand setDestinationPrefix(String destinationPrefix) {
        this.destinationPrefix = destinationPrefix;
        return this;
    }

    public DiffCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }
}

