/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.xerial.snappy.LoadSnappy;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyException;
import org.xerial.snappy.SnappyNative;

public class Snappy {
    public static byte[] compress(byte[] input) throws SnappyException {
        return Snappy.rawCompress(input, input.length);
    }

    public static int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws SnappyException {
        return Snappy.rawCompress(input, inputOffset, inputLength, output, outputOffset);
    }

    public static int compress(ByteBuffer uncompressed, ByteBuffer compressed) throws SnappyException {
        if (!uncompressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int uPos = uncompressed.position();
        int uLen = uncompressed.remaining();
        int compressedSize = SnappyNative.rawCompress(uncompressed, uPos, uLen, compressed, compressed.position());
        compressed.limit(compressed.position() + compressedSize);
        return compressedSize;
    }

    public static byte[] compress(char[] input) {
        return Snappy.rawCompress(input, input.length * 2);
    }

    public static byte[] compress(double[] input) {
        return Snappy.rawCompress(input, input.length * 8);
    }

    public static byte[] compress(float[] input) {
        return Snappy.rawCompress(input, input.length * 4);
    }

    public static byte[] compress(int[] input) {
        return Snappy.rawCompress(input, input.length * 4);
    }

    public static byte[] compress(long[] input) {
        return Snappy.rawCompress(input, input.length * 8);
    }

    public static byte[] compress(short[] input) {
        return Snappy.rawCompress(input, input.length * 2);
    }

    public static byte[] compress(String s) throws SnappyException {
        try {
            return Snappy.compress(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoder is not found");
        }
    }

    public static byte[] compress(String s, String encoding) throws UnsupportedEncodingException, SnappyException {
        byte[] data = s.getBytes(encoding);
        return Snappy.compress(data);
    }

    public static String getNativeLibraryVersion() {
        return SnappyNative.nativeLibraryVersion();
    }

    public static boolean isValidCompressedBuffer(byte[] input, int offset, int length) throws SnappyException {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        return SnappyNative.isValidCompressedBuffer(input, offset, length);
    }

    public static boolean isValidCompressedBuffer(ByteBuffer compressed) throws SnappyException {
        return SnappyNative.isValidCompressedBuffer(compressed, compressed.position(), compressed.remaining());
    }

    public static int maxCompressedLength(int byteSize) {
        return SnappyNative.maxCompressedLength(byteSize);
    }

    public static byte[] rawCompress(Object data, int byteSize) {
        byte[] buf = new byte[Snappy.maxCompressedLength(byteSize)];
        int compressedByteSize = SnappyNative.rawCompress(data, 0, byteSize, buf, 0);
        byte[] result = new byte[compressedByteSize];
        System.arraycopy(buf, 0, result, 0, compressedByteSize);
        return result;
    }

    public static int rawCompress(Object input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws SnappyException {
        if (input == null || output == null) {
            throw new NullPointerException("input or output is null");
        }
        int compressedSize = SnappyNative.rawCompress(input, inputOffset, inputLength, output, outputOffset);
        return compressedSize;
    }

    public static int rawUncompress(byte[] input, int inputOffset, int inputLength, Object output, int outputOffset) throws SnappyException {
        if (input == null || output == null) {
            throw new NullPointerException("input or output is null");
        }
        return SnappyNative.rawUncompress(input, inputOffset, inputLength, output, outputOffset);
    }

    public static byte[] uncompress(byte[] input) throws SnappyException {
        byte[] result = new byte[Snappy.uncompressedLength(input)];
        int byteSize = Snappy.uncompress(input, 0, input.length, result, 0);
        return result;
    }

    public static int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws SnappyException {
        return Snappy.rawUncompress(input, inputOffset, inputLength, output, outputOffset);
    }

    public static int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws SnappyException {
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!uncompressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int cPos = compressed.position();
        int cLen = compressed.remaining();
        int decompressedSize = SnappyNative.rawUncompress(compressed, cPos, cLen, uncompressed, uncompressed.position());
        uncompressed.limit(uncompressed.position() + decompressedSize);
        return decompressedSize;
    }

    public static char[] uncompressCharArray(byte[] input) throws SnappyException {
        return Snappy.uncompressCharArray(input, 0, input.length);
    }

    public static char[] uncompressCharArray(byte[] input, int offset, int length) throws SnappyException {
        int uncompressedLength = Snappy.uncompressedLength(input, offset, length);
        char[] result = new char[uncompressedLength / 2];
        int byteSize = SnappyNative.rawUncompress(input, offset, length, result, 0);
        return result;
    }

    public static double[] uncompressDoubleArray(byte[] input) throws SnappyException {
        int uncompressedLength = Snappy.uncompressedLength(input, 0, input.length);
        double[] result = new double[uncompressedLength / 8];
        int byteSize = SnappyNative.rawUncompress(input, 0, input.length, result, 0);
        return result;
    }

    public static int uncompressedLength(byte[] input) throws SnappyException {
        return SnappyNative.uncompressedLength(input, 0, input.length);
    }

    public static int uncompressedLength(byte[] input, int offset, int length) throws SnappyException {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        return SnappyNative.uncompressedLength(input, offset, length);
    }

    public static CompressedDataLength getUncompressedLength(byte[] input, int offset, int limit) throws SnappyException {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        long b = 0L;
        long result = 0L;
        int cursor = offset;
        if (cursor >= limit) {
            return null;
        }
        b = input[cursor++];
        result = b & 0x7FL;
        if (b >= 128L) {
            if (cursor >= limit) {
                return null;
            }
            b = input[cursor++];
            result |= (b & 0x7FL) << 7;
            if (b >= 128L) {
                if (cursor >= limit) {
                    return null;
                }
                b = input[cursor++];
                result |= (b & 0x7FL) << 14;
                if (b >= 128L) {
                    if (cursor >= limit) {
                        return null;
                    }
                    b = input[cursor++];
                    result |= (b & 0x7FL) << 21;
                    if (b >= 128L) {
                        if (cursor >= limit) {
                            return null;
                        }
                        b = input[cursor++];
                        result |= (b & 0x7FL) << 28;
                        if (b >= 16L) {
                            return null;
                        }
                    }
                }
            }
        }
        if (result > Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot uncompress byte array longer than 2^31-1: " + result);
        }
        return new CompressedDataLength(cursor, (int)result);
    }

    public static int uncompressedLength(ByteBuffer compressed) throws SnappyException {
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        return SnappyNative.uncompressedLength(compressed, compressed.position(), compressed.remaining());
    }

    public static float[] uncompressFloatArray(byte[] input) throws SnappyException {
        return Snappy.uncompressFloatArray(input, 0, input.length);
    }

    public static float[] uncompressFloatArray(byte[] input, int offset, int length) throws SnappyException {
        int uncompressedLength = Snappy.uncompressedLength(input, offset, length);
        float[] result = new float[uncompressedLength / 4];
        int byteSize = SnappyNative.rawUncompress(input, offset, length, result, 0);
        return result;
    }

    public static int[] uncompressIntArray(byte[] input) throws SnappyException {
        return Snappy.uncompressIntArray(input, 0, input.length);
    }

    public static int[] uncompressIntArray(byte[] input, int offset, int length) throws SnappyException {
        int uncompressedLength = Snappy.uncompressedLength(input, offset, length);
        int[] result = new int[uncompressedLength / 4];
        int byteSize = SnappyNative.rawUncompress(input, offset, length, result, 0);
        return result;
    }

    public static long[] uncompressLongArray(byte[] input) throws SnappyException {
        return Snappy.uncompressLongArray(input, 0, input.length);
    }

    public static long[] uncompressLongArray(byte[] input, int offset, int length) throws SnappyException {
        int uncompressedLength = Snappy.uncompressedLength(input, offset, length);
        long[] result = new long[uncompressedLength / 8];
        int byteSize = SnappyNative.rawUncompress(input, offset, length, result, 0);
        return result;
    }

    public static short[] uncompressShortArray(byte[] input) throws SnappyException {
        return Snappy.uncompressShortArray(input, 0, input.length);
    }

    public static short[] uncompressShortArray(byte[] input, int offset, int length) throws SnappyException {
        int uncompressedLength = Snappy.uncompressedLength(input, offset, length);
        short[] result = new short[uncompressedLength / 2];
        int byteSize = SnappyNative.rawUncompress(input, offset, length, result, 0);
        return result;
    }

    public static String uncompressString(byte[] input) throws SnappyException {
        try {
            return Snappy.uncompressString(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 decoder is not found");
        }
    }

    public static String uncompressString(byte[] input, int offset, int length) throws SnappyException {
        try {
            return Snappy.uncompressString(input, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 decoder is not found");
        }
    }

    public static String uncompressString(byte[] input, int offset, int length, String encoding) throws SnappyException, UnsupportedEncodingException {
        byte[] uncompressed = new byte[Snappy.uncompressedLength(input, offset, length)];
        int compressedSize = Snappy.uncompress(input, offset, length, uncompressed, 0);
        return new String(uncompressed, encoding);
    }

    public static String uncompressString(byte[] input, String encoding) throws SnappyException, UnsupportedEncodingException {
        byte[] uncompressed = Snappy.uncompress(input);
        return new String(uncompressed, encoding);
    }

    static {
        LoadSnappy.load();
    }

    public static class CompressedDataLength {
        public final int cursor;
        public final int uncompressedLength;

        public CompressedDataLength(int cursor, int uncompressedLength) {
            this.cursor = cursor;
            this.uncompressedLength = uncompressedLength;
        }
    }
}

